<?php

include_once('conectorBDS14.php');

class Acceso
{
  public $id;
  public $usuario;
  public $agent;
  public $ip;
  public $hora_i;
  public $fecha;
  public $hora_f;
  public $tipo;
  public $activa;
  public $tiempo_conexion;

  public function __construct($id, $usuario, $agent, $ip, $hora_i, $fecha, $hora_f, $tipo, $activa, $tiempo_conexion)
  {
    $this->id = $id;
    $this->usuario = $usuario;
    $this->agent = $agent;
    $this->ip = $ip;
    $this->hora_i = $hora_i;
    $this->fecha = $fecha;
    $this->hora_f = $hora_f;
    $this->tipo = $tipo;
    $this->activa = $activa;
    $this->tiempo_conexion = $tiempo_conexion;
  }
}


class AdministradorConecciones extends conectorS14
{

  public function insertaAcceso($usuario, $agent, $ip, $hora_i, $fecha, $hora_f, $tipo, $activa, $tiempo_conexion)
  {
    $sql = 'INSERT INTO logsesiones (usuario, agent, ip, hora_i, fecha, hora_f, tipo, activa, tiempo_conexion) 
    values ("' . $usuario . '","' . $agent . '","' . $ip . '","' . $hora_i . '","' . $fecha . '","' . $hora_f . '","' . $tipo . '","' . $activa . '","' . $tiempo_conexion . '");';
    $this->ejecutar($sql);
  }

  public function dameAccesos()
  {
    $sql = 'SELECT * FROM logsesiones';
    $result = $this->ejecutar($sql);
    $accesos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $acceso = new Acceso($fila['id'], $fila['usuario'], $fila['agent'], $fila['ip'], $fila['hora_i'], $fila['fecha'], $fila['hora_f'], $fila['tipo'], $fila['activa'], $fila['tiempo_conexion']);
      array_push($accesos, $acceso);
    }
    return $accesos;
  }

  public function dameAccesosPaginacion($pagina)
  {
    $sql = 'SELECT * FROM logsesiones  order by id desc LIMIT 20 OFFSET ' . (($pagina - 1) * 20) . '';
    $result = $this->ejecutar($sql);
    $accesos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $acceso = new Acceso($fila['id'], $fila['usuario'], $fila['agent'], $fila['ip'], $fila['hora_i'], $fila['fecha'], $fila['hora_f'], $fila['tipo'], $fila['activa'], $fila['tiempo_conexion']);
      array_push($accesos, $acceso);
    }
    return $accesos;
  }

  public function dameAceeso($id)
  {
    $sql = 'SELECT * FROM logsesiones WHERE id = ' . $id;
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $acceso = new Acceso($fila['id'], $fila['usuario'], $fila['agent'], $fila['ip'], $fila['hora_i'], $fila['fecha'], $fila['hora_f'], $fila['tipo'], $fila['activa'], $fila['tiempo_conexion']);
    return $acceso;
  }

  public function eliminaAccesos($id)
  {
    $sql = 'DELETE FROM logsesiones WHERE id = ' . $id;
    $this->ejecutar($sql);
  }

  public function cuentaAccesos()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }

  public function cuentaAgentes()
  {
    $sql = 'SELECT agent as navegador, COUNT(DISTINCT agent) as repeticiones FROM logsesiones group by agent';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }


  public function cuentaAccesosApple()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones WHERE agent LIKE "%Macintosh%"';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }

  public function cuentaAccesosWindows()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones WHERE agent LIKE "%Windows%"';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }

  public function cuentaAccesosIphone()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones WHERE agent LIKE "%iPhone%"';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }

  public function cuentaAccesosOtros()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones WHERE agent NOT LIKE "%Windows%" AND agent NOT LIKE "%Macintosh%" AND agent NOT LIKE "%iPhone%"';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }

  public function cuentaAccesosExitosos()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones WHERE tipo = "Correcto"';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }

  public function cuentaAccesosFallidos()
  {
    $sql = 'SELECT COUNT(*) FROM logsesiones WHERE tipo = "Error"';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila[0];
  }
}
