<?php

include_once('conectorBDS14.php');
include_once('adminUtil.php');
class ReporteBancoE{
  public $id;
  public $fecha_actualisacion;
  public $banco; 
  public $saldo_hoy;
  public $saldo_dia2;
  public $saldo_dia3;
  public $saldo_dia4;

  public function __construct($id, $fecha_actualisacion, $banco, $saldo_hoy, $saldo_dia2, $saldo_dia3, $saldo_dia4)
  {
      $this->id = $id;
      $this->fecha_actualisacion = $fecha_actualisacion;
      $this->banco = $banco;
      $this->saldo_hoy = $saldo_hoy;
      $this->saldo_dia2 = $saldo_dia2;
      $this->saldo_dia3 = $saldo_dia3;
      $this->saldo_dia4 = $saldo_dia4;
  }

}

class Empresa
{
  //SELECT `id`, `razon`, `rfc`, `calle`, `numero`, `colonia`, `cp`, `estado`, `logo`, `regimen`, `password_r`, `usuario` FROM `empresas` WHERE 1
  public $id;
  public $razon;
  public $rfc;
  public $calle;
  public $numero;
  public $colonia;
  public $cp;
  public $estado;
  public $logo;
  public $regimen;
  public $password_r;
  public $usuario;
  public $cuentas;
  public $dineroSinFacturar;
  public $movimientosSinFacturar;
  public $saldoBacos;

  function __construct($id, $razon, $rfc, $calle, $numero, $colonia, $cp, $estado, $logo, $regimen, $password_r, $usuario)
  {
    $this->id = $id;
    $this->razon = $razon;
    $this->rfc = $rfc;
    $this->calle = $calle;
    $this->numero = $numero;
    $this->colonia = $colonia;
    $this->cp = $cp;
    $this->estado = $estado;
    $this->logo = $logo;
    $this->regimen = $regimen;
    $this->password_r = $password_r;
    $this->usuario = $usuario;
  }
}


class Reporte{
  public $dia1;
  public $dia2;
  public $dia3;
  public $suma;

  function __construct($dia1, $dia2, $dia3, $suma){
    $this->dia1 = $dia1;
    $this->dia2 = $dia2;
    $this->dia3 = $dia3;
    $this->suma = $suma;
  }
}

class CuentaEmpresa
{
  //select banco,id,color,texto,nombre_corto,moneda,alerta from bancos where razon='$razon' and status_banco='AC'
  public $banco;
  public $id;
  public $color;
  public $texto;
  public $nombre_corto;
  public $moneda;
  public $alerta;
  public $saldo;
  public $datos3Dias;


  function __construct($banco, $id, $color, $texto, $nombre_corto, $moneda, $alerta)
  {
    $this->banco = $banco;
    $this->id = $id;
    $this->color = $color;
    $this->texto = $texto;
    $this->nombre_corto = $nombre_corto;
    $this->moneda = $moneda;
    $this->alerta = $alerta;
  }
}


class AdminEmpresas extends conectorS14
{


  public function obtenerUltimasTresFechas()
  {
    $resultados = [];
    $fecha = new DateTime();
    $resultados[] = date('Y-m-d');

    for($i = 0; $i < 3; $i++){
      $fecha->modify('-1 day');
      if($this->queDiaSemanaEs($fecha->format('Y-m-d')) == 0){
        $fecha->modify('-2 day');
      }
      if($this->queDiaSemanaEs($fecha->format('Y-m-d')) == 6){
        $fecha->modify('-1 day');
      }
      $resultados[] = $fecha->format('Y-m-d');
    }

    //añadir hoy 

    return $resultados;
  }

  function queDiaSemanaEs($fecha){
    $dia = date('w', strtotime($fecha));
    return $dia;
  }


  public function dameSuma3Dias($empresa){
    $fechas = $this->obtenerUltimasTresFechas();
    $suma = 0;
    $datos = [];

    foreach($fechas as $fecha){
      //echo "Esta es la fecha " . $fecha;
      $saldo =  $this->dameSaldosPorFechasRetiros($empresa, $fecha);
      $datos[] = $fecha . " SALIDAS $ " .  number_format(floatval($saldo), 2) ;
      $suma = $suma + $saldo;

    }

    $datos[] = "TOTAL: " . number_format($suma, 2);
    return $datos;

  }


  public function dameSaldosPorFechasRetiros($empresa, $fecha){
    $sql = "SELECT sum(retiro) as suma FROM `captura_edo_cta` where cuenta = $empresa and fecha = '$fecha';";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }

  public function dameSaldoBanco($banco, $moneda)
  {
    $adminUtil = new AdministradorUtil();
    $tipo_cambio = $adminUtil->dameUltimoTipoCambio();
    $saldo_fin = 0;
    $saldo_fin_dolares = 0;
    $saldo_fin_dolares_2 = 0;
    $saldo_fin2 = 0;
    $sql = "select sum(deposito) as depositos,sum(retiro) as retiros, cuenta as banco from captura_edo_cta where cuenta='$banco'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $depositos = $fila['depositos'];
    $retiros = $fila['retiros'];
    if ($moneda <> "Dolares") {
      $saldo_fin = ($saldo_fin + ($depositos - $retiros));
    } else {
      $saldo_fin_dolares = ($saldo_fin_dolares + ($depositos - $retiros));
    }
    $saldo = ($depositos - $retiros);

    $saldo_fin_dolares_2 = ($saldo_fin_dolares + $saldo_fin_dolares_2);
    $saldo_fin2 = ($saldo_fin + $saldo_fin2);

    return ($saldo_fin_dolares * $tipo_cambio->tipo_cambio) + $saldo_fin;
  }

  public function dameDineroSinFacturarPorEmpresa($empresa)
  {
    $sql = "select sum(monto) as suma from pagos where factura='Sin Facturar' and tipo_movimiento='Deposito' and empresa='$empresa'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }

  public function dameCuentasEmpresa($razon)
  {
    $errorNacimiento = 63909.72;
    $sql = "select banco,id,color,texto,nombre_corto,moneda,alerta from bancos where razon='$razon' and status_banco='AC'";
    $result = $this->ejecutar($sql);
    $cuentas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $cuenta = new CuentaEmpresa($fila['banco'], $fila['id'], $fila['color'], $fila['texto'], $fila['nombre_corto'], $fila['moneda'], $fila['alerta']);
      $cuenta->datos3Dias = $this->dameUltimoRegistroSaldos($fila['id']);
     
      array_push($cuentas, $cuenta);
    }
    return $cuentas;
  }

  public function dameUltimoRegistroSaldos($cuenta){
    $sql ="SELECT `id`, `fecha_actualisacion`, `banco`, `saldo_hoy`, `saldo_dia2`, `saldo_dia3`, `saldo_dia4` FROM `his_saldos_bancos` WHERE banco = '$cuenta' order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $reporte = new ReporteBancoE($fila['id'], $fila['fecha_actualisacion'], $fila['banco'], $fila['saldo_hoy'], $fila['saldo_dia2'], $fila['saldo_dia3'], $fila['saldo_dia4']);
    return $reporte;
  
  }



  public function cuentaMovimientosSinFacturaPorEmpresa($empresa)
  {
    $sql = "select count(*) as suma from pagos where factura='Sin Facturar' and empresa='$empresa' and tipo_movimiento<>'Retiro'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }

  public function cuentaEmpresasSinLogo()
  {
    $sql = "select count(*) as suma from empresas where logo='' or logo is null";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }

  public function cuentaEmpreas()
  {
    $sql = "select count(*) as suma from empresas";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }


  public function dameEmpresas()
  {
    $sql = 'SELECT * FROM empresas order by razon asc';
    $result = $this->ejecutar($sql);
    $empresas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $empresa = new Empresa($fila['id'], $fila['razon'], $fila['rfc'], $fila['calle'], $fila['numero'], $fila['colonia'], $fila['cp'], $fila['estado'], $fila['logo'], $fila['regimen'], $fila['password_r'], $fila['usuario']);
      $empresa->cuentas = $this->dameCuentasEmpresa($fila['id']);
      //$empresa->dineroSinFacturar = $this->dameDineroSinFacturarPorEmpresa($fila['id']);
      //$empresa->movimientosSinFacturar = $this->cuentaMovimientosSinFacturaPorEmpresa($fila['id']);
      //$empresa->saldoBacos = $this->dameSaldoBanco($fila['id'], "Pesos");
      array_push($empresas, $empresa);
    }
    return $empresas;
  }

  public function dameSaltoEmpresa($empresa)
  {
  }
  public function dameRetirosYDepositos($cuenta)
  {
    $sql = "select sum(deposito) as depositos,sum(retiro) as retiros, cuenta as banco from captura_edo_cta where cuenta='$cuenta'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $depositos = $fila['depositos'];
    $retiros = $fila['retiros'];
    $saldo = ($depositos - $retiros);
    return $saldo;
  }

  public function dameEmpresasLite()
  {
    $sql = 'SELECT * FROM empresas order by razon asc';
    $result = $this->ejecutar($sql);
    $empresas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $empresa = new Empresa($fila['id'], $fila['razon'], $fila['rfc'], $fila['calle'], $fila['numero'], $fila['colonia'], $fila['cp'], $fila['estado'], $fila['logo'], $fila['regimen'], $fila['password_r'], $fila['usuario']);
      array_push($empresas, $empresa);
    }
    return $empresas;
  }

  public function dameEmpresa($id)
  {
    $sql = "SELECT * FROM empresas where id='$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $empresa = new Empresa($fila['id'], $fila['razon'], $fila['rfc'], $fila['calle'], $fila['numero'], $fila['colonia'], $fila['cp'], $fila['estado'], $fila['logo'], $fila['regimen'], $fila['password_r'], $fila['usuario']);
    $empresa->cuentas = $this->dameCuentasEmpresa($fila['id']);
    $empresa->dineroSinFacturar = $this->dameDineroSinFacturarPorEmpresa($fila['id']);
    $empresa->movimientosSinFacturar = $this->cuentaMovimientosSinFacturaPorEmpresa($fila['id']);
    $empresa->saldoBacos = $this->dameSaldoBanco($fila['id'], "Pesos");
    return $empresa;
  }
}
