<?php 
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="REPORTE-CUENTA-'.$_POST['banca'].'.xls"');
include_once('adminPagos.php');
$admin = new AdministradorPagos();
$reporte = $admin->dameReportePorCuentaFechas($_POST['banca'], $_POST['fecha_inicio'], $_POST['fecha_fin']);
function formatearFecha($fecha)
{
  $dia = substr($fecha, 8, 2);
  $mes = substr($fecha, 5, 2);
  $anio = substr($fecha, 0, 4);
  return $dia . '/' . $mes . '/' . $anio;
}
?>

<div class="padding">
          <div class="box">
            <div class="box-header">
              <h2>Reporte de </h2>
            </div>
            <div class="table-responsive">
            <table id="tablaFacura" class="table table-striped hover">
              <thead>
                <tr>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">ID</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">ID PAGO</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Fecha de Banco</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Referencia</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Descripcion</th>

                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Deposito</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Retiro</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="6">Saldo</th>



                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4" hidden>Deposito h</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5" hidden>Retiro h</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="6" hidden>Saldo h</th>


                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="8">ID de Captura</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="9">Descripcion Detallada</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="10s">Tipo de Movimiento</th>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Fecha de Sistema</th>

                </tr>
              </thead>
              <tbody>
                <?php

                foreach ($reporte as $rep) {
                  echo '<tr>
                  <td>' . ($rep->id)  . '</td>
                  <td>' . ($rep->id_pago)  . '</td>

                  <td>' . formatearFecha($rep->fecha)  . '</td>
                  <td>' . $rep->referencia . '</td>
                  <td>' . $rep->descripcion . '</td>
                  <td>$' . number_format($rep->deposito, 2)  . '</td>
                  <td>$' . number_format($rep->retiro, 2)  . '</td>
                  <td>$' . number_format($rep->saldo, 2)  . '</td>
                  <td hidden>$' . ($rep->deposito)  . '</td>
                  <td hidden>$' . ($rep->retiro)  . '</td>
                  <td hidden>$' . ($rep->saldo)  . '</td>
                  <td>' . $rep->id_captura . '</td>
                  <td>' . $rep->descrip_det . '</td>
                  <td>' . $rep->tipo_movimiento . '</td>
                  <td>' . formatearFecha($rep->fecha_sistema)  . '</td>
                </tr>';
                }


                ?>

              </tbody>
            </table>
            </div>
          </div>
        </div>