<?php
// Obtener la fecha actual para el nombre del archivo (formato: web_dd-mm-yyyy.txt)
$fecha = date('d-m-Y');
$log_file = "web_$fecha.txt";

// Si el archivo no existe, lo crea
if (!file_exists($log_file)) {
    // Crear el archivo vacío
    file_put_contents($log_file, "Archivo creado el $fecha" . PHP_EOL);
}

// Verificación del webhook con método GET
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['hub_challenge']) && isset($_GET['hub_verify_token']) && $_GET['hub_verify_token'] == 's14t3k') {
    // Guarda la verificación en el archivo de log
    file_put_contents($log_file, "GET verification: " . json_encode($_GET) . PHP_EOL, FILE_APPEND);
    
    // Responde con el 'hub_challenge' para verificar el webhook
    echo $_GET['hub_challenge'];
} 

// Manejo de las solicitudes POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtén el cuerpo de la solicitud POST
    $input = file_get_contents('php://input');
    
    // Guarda el contenido del POST en el archivo de log
    file_put_contents($log_file, "POST data: " . $input . PHP_EOL, FILE_APPEND);

    // Opcional: Responde con un código HTTP 200 para confirmar recepción
    http_response_code(200);
}
?>
