<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>Banca Sistema 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banca Sistema 14: Dispersion y gestión de pagos." />
    <meta name="author" content="StackBros" />
    <meta name="keywords" content="Banca Sistema 14" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow" />
    <meta name="theme-color" content="#ffffff">

    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Google Font Family link -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- Vendor css -->
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

    <!-- Icons css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

    <!-- Theme Config js -->
    <script src="assets/js/config.js"></script>
</head>

<body>
    <style>
        .icon-big {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 64px;
            /* tamaño del contenedor */
            height: 64px;
            /* círculo opcional */
            /* fondo verde translúcido opcional */
            font-size: 2rem;
            /* tamaño del ícono */
        }

        .icon-color-green i {
            color: #28a745;
            /* verde Bootstrap */
        }



        .icon-color-red i {
            color: #dc3545;
        }

        /* Permite que la etiqueta “salga” un poco del borde izquierdo como en la captura */
        .retiro-card {
            overflow: visible;
            /* importante para que se vea por fuera */
            border-radius: 12px;
        }

        /* Etiqueta vertical “Retiro” */
        .retiro-label {
            position: absolute;
            left: 5px;
            /* sobresale un poco del borde, ajusta a tu gusto */
            top: 98%;
            transform: translateY(-50%) rotate(-90deg);
            transform-origin: left top;
            /* asegura buena referencia al rotar */
            /* texto oscuro como en la imagen */
            line-height: 1;
            letter-spacing: .3px;
            white-space: nowrap;
            background: transparent;
            /* sin fondo, como la captura */
            padding: 0;
            /* sin padding */
        }
    </style>

    <?php
    function formatearFechaEsp($fecha)
    {
        // Aseguramos que se maneje correctamente la fecha
        $timestamp = strtotime($fecha);

        // Días y meses en español
        $dias = [
            "Domingo",
            "Lunes",
            "Martes",
            "Miércoles",
            "Jueves",
            "Viernes",
            "Sábado"
        ];
        $meses = [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre"
        ];

        // Obtenemos los componentes
        $diaSemana = $dias[date("w", $timestamp)];
        $dia = date("d", $timestamp);
        $mes = $meses[date("n", $timestamp) - 1];
        $anio = date("Y", $timestamp);

        // Retornamos en el formato solicitado
        return "$diaSemana $dia/$mes/$anio";
    }

    ?>
    <!-- START Wrapper -->
    <div class="app-wrapper">
        <!-- Topbar Start -->
        <?php include_once 'template/header.php'; ?>
        <!-- Topbar End -->

        <!-- App Menu Start -->
        <?php include_once 'template/barra.php'; ?>
        <!-- App Menu End -->

        <!-- ==================================================== -->
        <!-- Start right Content here -->
        <!-- ==================================================== -->
        <div class="page-content">

            <!-- Start Container Fluid -->
            <div class="container-fluid">

                <!-- ========== Page Title Start ========== -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="mb-0">Comprobantes</h4>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Movimientos</a></li>
                                <li class="breadcrumb-item active">Comprobantes</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <!-- ========== Page Title End ========== -->
                <div class="row">







                    <div class="col-sm-12">
                        <div class="card card-body position-relative retiro-card">

                            <!-- Etiqueta vertical como en la imagen -->
                            <small class="retiro-label">Retiro Banca 14</small>

                            <!-- Contenido principal -->
                            <div class="d-flex align-items-start justify-content-start">
                                <span class="icon-big icon-color-red">
                                    <i class="fa fa-arrow-up"></i>
                                </span>

                                <div class="w-100">
                                    <p class="mb-1">Retiro banca 14, Referencia 10HBANCA93340</p>
                                    <div class="d-flex justify-content-between align-items-end">
                                        <p class="mb-0">
                                            <span class="text-muted"></span>
                                            <span style="font-style: italic;"><?= formatearFechaEsp(date('Y-m-d')) ?></span>
                                        </p>
                                        <p class="mb-0 fw-bold" style="font-size:1.1rem;">$-4,000.00</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-sm-12">
                        <div class="card card-body position-relative retiro-card">

                            <!-- Etiqueta vertical como en la imagen -->
                            <small class="retiro-label">Retiro Banca 14</small>

                            <!-- Contenido principal -->
                            <div class="d-flex align-items-start justify-content-start">
                                <span class="icon-big icon-color-red">
                                    <i class="fa fa-arrow-up"></i>
                                </span>

                                <div class="w-100">
                                    <p class="mb-1">Retiro banca 14, Referencia 10HBANCA93340</p>
                                    <div class="d-flex justify-content-between align-items-end">
                                        <p class="mb-0">
                                            <span class="text-muted"></span>
                                            <span style="font-style: italic;"><?= formatearFechaEsp(date('Y-m-d')) ?></span>
                                        </p>
                                        <p class="mb-0 fw-bold" style="font-size:1.1rem;">$-4,000.00</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="card card-body position-relative retiro-card">

                        <!-- Etiqueta vertical como en la imagen -->
                        <small class="retiro-label">Retiro Banca 14</small>

                        <!-- Contenido principal -->
                        <div class="d-flex align-items-start justify-content-start">
                            <span class="icon-big icon-color-red">
                                <i class="fa fa-arrow-up"></i>
                            </span>

                            <div class="w-100">
                                <p class="mb-1">Retiro banca 14, Referencia 10HBANCA93340</p>
                                <div class="d-flex justify-content-between align-items-end">
                                    <p class="mb-0">
                                        <span class="text-muted"></span>
                                        <span style="font-style: italic;"><?= formatearFechaEsp(date('Y-m-d')) ?></span>
                                    </p>
                                    <p class="mb-0 fw-bold" style="font-size:1.1rem;">$-4,000.00</p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>





            </div>
            <!-- End Container Fluid -->

            <!-- Footer Start -->
            <?php include_once 'template/footer.php'; ?>
            <!-- Footer End -->

        </div>
        <!-- ==================================================== -->
        <!-- End Page Content -->
        <!-- ==================================================== -->

    </div>
    <!-- END Wrapper -->

    <!-- Vendor Javascript -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App Javascript -->
    <script src="assets/js/app.js"></script>

    <!-- Vector Map Js -->
    <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world.js"></script>

    <!-- Dashboard Js -->
    <script src="assets/js/pages/dashboard.js"></script>

</body>

</html>