<!DOCTYPE html>
<html lang="en">

<head>
     <!-- Title Meta -->
     <meta charset="utf-8" />
     <title>Banca Sistema 14</title>
     <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <meta name="description" content="Banca Sistema 14: Dispersion y gestión de pagos." />
     <meta name="author" content="StackBros" />
     <meta name="keywords" content="Banca Sistema 14" />
     <meta http-equiv="X-UA-Compatible" content="IE=edge" />
     <meta name="robots" content="index, follow" />
     <meta name="theme-color" content="#ffffff">

     <!-- App favicon -->
     <link rel="shortcut icon" href="assets/images/favicon.ico">

     <!-- Google Font Family link -->
     <link rel="preconnect" href="https://fonts.googleapis.com">
     <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
     <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

     <!-- Vendor css -->
     <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

     <!-- Icons css -->
     <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

     <!-- App css -->
     <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

     <!-- Theme Config js -->
     <script src="assets/js/config.js"></script>
</head>

<body>
     <style>
          /* Componente aislado: Botón circular con texto rotando */
          .s14-rotbtn {
               cursor: pointer;
               border: none;
               background: #7808d0;
               color: #fff;
               width: 100px;
               height: 100px;
               border-radius: 50%;
               overflow: hidden;
               position: relative;
               display: grid;
               place-content: center;
               transition: background 300ms, transform 200ms;
               font-weight: 600;

               /* Resets anti-Bootstrap */
               padding: 0;
               line-height: 1;
               text-align: center;
               box-shadow: none;
               outline: none;
               appearance: none;
               /* Evita estilos del navegador */
               -webkit-appearance: none;
          }

          .s14-rotbtn__text {
               position: absolute;
               inset: 0;
               margin: 0;
               /* Evita margin por defecto en <p> de BS */
               animation: s14-text-rotation 8s linear infinite;
               pointer-events: none;
               /* No interfiere con el click */
          }

          .s14-rotbtn__text>span {
               position: absolute;
               transform: rotate(calc(19deg * var(--index)));
               inset: 7px;
          }

          .s14-rotbtn__circle {
               position: relative;
               width: 40px;
               height: 40px;
               overflow: hidden;
               background: #fff;
               color: #7808d0;
               border-radius: 50%;
               display: flex;
               align-items: center;
               justify-content: center;

               /* Resets anti-Bootstrap */
               box-shadow: none;
          }

          .s14-rotbtn__icon {
               display: block;
          }

          .s14-rotbtn__icon--copy {
               position: absolute;
               transform: translate(-150%, 150%);
          }

          .s14-rotbtn:hover {
               background: #000;
               transform: scale(1.05);
          }

          .s14-rotbtn:hover .s14-rotbtn__icon {
               color: #000;
          }

          .s14-rotbtn:hover .s14-rotbtn__icon:first-child {
               transition: transform 0.3s ease-in-out;
               transform: translate(150%, -150%);
          }

          .s14-rotbtn:hover .s14-rotbtn__icon--copy {
               transition: transform 0.3s ease-in-out 0.1s;
               transform: translate(0);
          }

          @keyframes s14-text-rotation {
               to {
                    rotate: 360deg;
               }
          }

          .Btn {
               display: flex;
               align-items: center;
               justify-content: flex-start;
               width: 45px;
               height: 45px;
               border: none;
               border-radius: 50%;
               cursor: pointer;
               position: relative;
               overflow: hidden;
               transition-duration: .3s;
               box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.199);
               background-color: rgb(255, 65, 65);
          }

          /* plus sign */
          .sign {
               width: 100%;
               transition-duration: .3s;
               display: flex;
               align-items: center;
               justify-content: center;
          }

          .sign svg {
               width: 17px;
          }

          .sign svg path {
               fill: white;
          }

          /* text */
          .text {
               position: absolute;
               right: 0%;
               width: 0%;
               opacity: 0;
               color: white;
               font-size: 1.2em;
               font-weight: 600;
               transition-duration: .3s;
          }

          /* hover effect on button width */
          .Btn:hover {
               width: 200px;
               border-radius: 40px;
               transition-duration: .3s;
          }

          .Btn:hover .sign {
               width: 30%;
               transition-duration: .3s;
               padding-left: 20px;
          }

          /* hover effect button's text */
          .Btn:hover .text {
               opacity: 1;
               width: 70%;
               transition-duration: .3s;
               padding-right: 10px;
          }

          /* button click effect*/
          .Btn:active {
               transform: translate(2px, 2px);
          }
     </style>
     <!-- START Wrapper -->
     <div class="app-wrapper">
          <!-- Topbar Start -->
          <?php include_once 'template/header.php'; ?>
          <!-- Topbar End -->

          <!-- App Menu Start -->
          <?php include_once 'template/barra.php'; ?>
          <!-- App Menu End -->

          <!-- ==================================================== -->
          <!-- Start right Content here -->
          <!-- ==================================================== -->
          <div class="page-content">

               <!-- Start Container Fluid -->
               <div class="container-fluid">

                    <!-- ========== Page Title Start ========== -->
                    <div class="row">
                         <div class="col-12">
                              <div class="page-title-box">
                                   <h4 class="mb-0">Inicio Banca</h4>
                                   <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
                                        <li class="breadcrumb-item active">Inicio Banca</li>
                                   </ol>
                              </div>
                         </div>
                    </div>
                    <!-- ========== Page Title End ========== -->

                    <div class="row">
                         <!-- Card 1 -->
                         <div class="col-md-12 col-xl-12">
                              <div class="card">
                                   <div class="card-body">
                                        <div class="row">
                                             <div class="col-6">
                                                  <div class="avatar-md bg-primary bg-opacity-10 rounded-circle">
                                                       <iconify-icon icon="solar:globus-outline"
                                                            class="fs-32 text-primary avatar-title"></iconify-icon>
                                                  </div>
                                             </div>
                                             <div class="col-6 text-end">
                                                  <p class="text-muted mb-0 text-truncate">Saldo de la cuenta</p>
                                                  <h3 class="text-dark mt-2 mb-0">$15,352.00</h3>
                                             </div>
                                        </div>
                                   </div>
                                   <div class="card-footer border-0 py-2 bg-light bg-opacity-50 mx-2 mb-2">
                                        <div class="d-flex align-items-center justify-content-between">
                                             <div>
                                                  <span class="text-success">Nombre de la cartera</span>
                                                  <span class="text-muted ms-1 fs-12">Ultimo login: 01/01/2076</span>
                                             </div>
                                        </div>
                                   </div>
                              </div>
                         </div>

                    </div>




                    <div class="row">
                         <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                              <a href="retiro.php">
                                   <div class="card mb-3 mb-xl-0" style="align-items: center; padding-top: 18px; height: 150px;">
                                        <button type="button" class="s14-rotbtn">
                                             <p class="s14-rotbtn__text">
                                                  <span style="--index: 0;">R</span>
                                                  <span style="--index: 1;">E</span>
                                                  <span style="--index: 2;">T</span>
                                                  <span style="--index: 3;">I</span>
                                                  <span style="--index: 4;">R</span>
                                                  <span style="--index: 5;">A</span>
                                                  <span style="--index: 6;">R</span>
                                                  <!-- <span style="--index: 7;"> </span>
                                                  <span style="--index: 8;">C</span>
                                                  <span style="--index: 9;">S</span>
                                                  <span style="--index: 10;">S</span>
                                                  <span style="--index: 11;"> </span>
                                                  <span style="--index: 12;">B</span>
                                                  <span style="--index: 13;">U</span>
                                                  <span style="--index: 14;">T</span>
                                                  <span style="--index: 15;">T</span>
                                                  <span style="--index: 16;">O</span>
                                                  <span style="--index: 17;">N</span> -->
                                             </p>

                                             <div class="s14-rotbtn__circle">
                                                  <svg
                                                       viewBox="0 0 14 15"
                                                       fill="none"
                                                       xmlns="http://www.w3.org/2000/svg"
                                                       class="s14-rotbtn__icon"
                                                       width="14">
                                                       <path
                                                            d="M13.376 11.552l-.264-10.44-10.44-.24.024 2.28 6.96-.048L.2 12.56l1.488 1.488 9.432-9.432-.048 6.912 2.304.024z"
                                                            fill="currentColor" />
                                                  </svg>

                                                  <svg
                                                       viewBox="0 0 14 15"
                                                       fill="none"
                                                       width="14"
                                                       xmlns="http://www.w3.org/2000/svg"
                                                       class="s14-rotbtn__icon s14-rotbtn__icon--copy">
                                                       <path
                                                            d="M13.376 11.552l-.264-10.44-10.44-.24.024 2.28 6.96-.048L.2 12.56l1.488 1.488 9.432-9.432-.048 6.912 2.304.024z"
                                                            fill="currentColor" />
                                                  </svg>
                                             </div>
                                        </button>

                                   </div> <!-- end card -->
                              </a>
                         </div>








                         <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                              <a href="contactos.php">
                                   <div class="card mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px;">


                                        <!-- From Uiverse.io by vinodjangid07 -->
                                        <button class="Btn">

                                             <div class="sign">
                                                  <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                       <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 21a9 9 0 1 0 0-18 9 9 0 0 0 0 18Zm0 0a8.949 8.949 0 0 0 4.951-1.488A3.987 3.987 0 0 0 13 16h-2a3.987 3.987 0 0 0-3.951 3.512A8.948 8.948 0 0 0 12 21Zm3-11a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                  </svg>
                                             </div>

                                             <div class="text">Contactos</div>
                                        </button>





                                   </div> <!-- end card -->
                              </a>
                         </div>
                         <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                              <a href="movimientos.php">
                                   <div class="card mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px;">
                                        <button class="Btn">

                                             <div class="sign">
                                                  <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                       <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3M3.22302 14C4.13247 18.008 7.71683 21 12 21c4.9706 0 9-4.0294 9-9 0-4.97056-4.0294-9-9-9-3.72916 0-6.92858 2.26806-8.29409 5.5M7 9H3V5" />
                                                  </svg>
                                             </div>

                                             <div class="text">Movimientos</div>
                                        </button>
                                   </div> <!-- end card -->
                              </a>
                         </div>

                         <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                              <a href="comprobantes.php">

                                   <div class="card mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px;">
                                        <button class="Btn">

                                             <div class="sign">
                                                  <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                       <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 17v-5h1.5a1.5 1.5 0 1 1 0 3H5m12 2v-5h2m-2 3h2M5 10V7.914a1 1 0 0 1 .293-.707l3.914-3.914A1 1 0 0 1 9.914 3H18a1 1 0 0 1 1 1v6M5 19v1a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-1M10 3v4a1 1 0 0 1-1 1H5m6 4v5h1.375A1.627 1.627 0 0 0 14 15.375v-1.75A1.627 1.627 0 0 0 12.375 12H11Z" />
                                                  </svg>
                                             </div>

                                             <div class="text">Comprobantes</div>
                                        </button>
                                   </div> <!-- end card -->
                              </a>
                         </div>

                         <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                              <div class="card mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px;">
                                   <button class="Btn">

                                        <div class="sign">
                                             <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                  <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 10V4a1 1 0 0 0-1-1H9.914a1 1 0 0 0-.707.293L5.293 7.207A1 1 0 0 0 5 7.914V20a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2M10 3v4a1 1 0 0 1-1 1H5m5 6h9m0 0-2-2m2 2-2 2" />
                                             </svg>
                                        </div>

                                        <div class="text">Plantillas</div>
                                   </button>
                              </div> <!-- end card -->
                         </div>

                    </div> <!-- end row -->




               </div>
               <!-- End Container Fluid -->

               <!-- Footer Start -->
               <?php include_once 'template/footer.php'; ?>

               <!-- Footer End -->

          </div>
          <!-- ==================================================== -->
          <!-- End Page Content -->
          <!-- ==================================================== -->

     </div>
     <!-- END Wrapper -->

     <!-- Vendor Javascript -->
     <script src="assets/js/vendor.min.js"></script>

     <!-- App Javascript -->
     <script src="assets/js/app.js"></script>

     <!-- Vector Map Js -->
     <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
     <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
     <script src="assets/vendor/jsvectormap/maps/world.js"></script>

     <!-- Dashboard Js -->
     <script src="assets/js/pages/dashboard.js"></script>

</body>

</html>