<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>Banca Sistema 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banca Sistema 14: Dispersion y gestión de pagos." />
    <meta name="author" content="StackBros" />
    <meta name="keywords" content="Banca Sistema 14" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow" />
    <meta name="theme-color" content="#ffffff">

    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Google Font Family link -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- Vendor css -->
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

    <!-- Icons css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

    <!-- Theme Config js -->
    <script src="assets/js/config.js"></script>
</head>

<body>

    <!-- START Wrapper -->
    <div class="app-wrapper">
        <!-- Topbar Start -->
        <?php include_once 'template/header.php'; ?>
        <!-- Topbar End -->

        <!-- App Menu Start -->
        <?php include_once 'template/barra.php'; ?>
        <!-- App Menu End -->

        <!-- ==================================================== -->
        <!-- Start right Content here -->
        <!-- ==================================================== -->
        <div class="page-content">

            <!-- Start Container Fluid -->
            <div class="container-fluid">

                <!-- ========== Page Title Start ========== -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="mb-0">Banca 14</h4>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Retiros</a></li>
                                <li class="breadcrumb-item active">Retirar</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <!-- ========== Page Title End ========== -->

                <div class="row">

                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Retiro 1</h4>
                                <p class="sub-header">
                                    Ingresa los datos del beneficiario.
                                </p>

                                <form>

                                    <div class="row">
                                        <div class="mb-2 col-md-2">
                                            <label for="inputState" class="form-label">Beneficiario <code>*</code></label>
                                            <select id="inputState" class="form-select">
                                                <option>Choose</option>
                                                <option>Option 1</option>
                                                <option>Option 2</option>
                                                <option>Option 3</option>

                                            </select>
                                        </div>

                                        <div class="mb-2 col-md-2">
                                            <label for="inputCity" class="form-label">Clabe / Tarjeta <code>*</code></label>
                                            <input type="text" class="form-control" id="inputCity">
                                        </div>

                                        <div class="mb-2 col-md-2">
                                            <label for="inputZip" class="form-label">Monto <code>*</code></label>
                                            <input type="text" class="form-control" id="inputZip">
                                        </div>

                                        <div class="mb-2 col-md-2">
                                            <label for="inputZip" class="form-label">Correo</label>
                                            <input type="text" class="form-control" id="inputZip">
                                        </div>
                                        <div class="mb-2 col-md-2">
                                            <label for="inputZip" class="form-label">Teléfono</label>
                                            <input type="text" class="form-control" id="inputZip">
                                        </div>
                                        <div class="mb-2 col-md-2">
                                            <label for="inputZip" class="form-label">Concepto <code>*</code></label>
                                            <input type="text" class="form-control" id="inputZip">
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-center align-items-center" style="text-align: center;">
                        <div class="col-xl-2 col-md-4 col-sm-8">
                            <div class="card shadow">
                                <div class="card-body">
                                    <h4 class="header-title mb-3">Ingresa el 2FA</h4>
                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <input type="text" class="form-control text-center" id="inputCity" placeholder="Código 2FA">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div style="align-items: center; text-align: center; margin-top: 20px;">
                        <button id="btnEnviar" class="btn btn-primary d-inline-flex align-items-center" type="button">
                            <span class="btn-text">Enviar</span>
                            <!-- Spinner (oculto inicialmente) -->
                            <span class="spinner-border spinner-border-sm ml-2 d-none" role="status" aria-hidden="true"></span>
                            <!-- Check (oculto inicialmente) -->
                            <span class="ml-2 d-none" id="iconCheck" aria-hidden="true">
                                <!-- SVG de check -->
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor">
                                    <path fill-rule="evenodd" d="M13.485 1.929a.75.75 0 0 1 .086 1.057l-7 8a.75.75 0 0 1-1.09.04l-3-3a.75.75 0 1 1 1.06-1.06l2.42 2.42 6.47-7.39a.75.75 0 0 1 1.054-.067z" />
                                </svg>
                            </span>
                        </button>
                    </div>

                </div>






            </div>
            <!-- End Container Fluid -->

            <!-- Footer Start -->
            <?php include_once 'template/footer.php'; ?>
            <!-- Footer End -->

        </div>
        <!-- ==================================================== -->
        <!-- End Page Content -->
        <!-- ==================================================== -->

    </div>
    <!-- END Wrapper -->

    <!-- Vendor Javascript -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App Javascript -->
    <script src="assets/js/app.js"></script>

    <!-- Vector Map Js -->
    <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world.js"></script>

    <!-- Dashboard Js -->
    <script src="assets/js/pages/dashboard.js"></script>

    <script>
        (function() {
            const btn = document.getElementById('btnEnviar');
            const text = btn.querySelector('.btn-text');
            const spinner = btn.querySelector('.spinner-border');
            const check = document.getElementById('iconCheck');

            btn.addEventListener('click', function() {
                // Evitar doble clic
                if (btn.disabled) return;

                // Estado: Enviando...
                btn.disabled = true;
                spinner.classList.remove('d-none');
                check.classList.add('d-none');
                text.textContent = 'Enviando...';

                // Después de 5 segundos, mostrar "Enviado" y cambiar a verde
                setTimeout(() => {
                    spinner.classList.add('d-none');
                    check.classList.remove('d-none');
                    text.textContent = 'Enviado';

                    // Cambiar de azul a verde
                    btn.classList.remove('btn-primary');
                    btn.classList.add('btn-success');

                    // (Opcional) Si quieres permitir volver a enviar, reactivar:
                    // btn.disabled = false; text.textContent = 'Enviar'; check.classList.add('d-none');
                    // btn.classList.remove('btn-success'); btn.classList.add('btn-primary');
                }, 5000);
            });
        })();
    </script>
</body>

</html>