<?php

include_once('conectorBDS14.php');
include_once "encriptador.php";


//INSERT INTO `pagos`(`id`, `nombre`, `monto`, `factura`, `empresa`, `status`, `fecha_asignacion`, `fecha_operacion`, `hora_operacion`, `fecha_captura`, `tipo_movimiento`, `saldo_acreditable`, `banco`, `saldo`, `usuario_registra`, `id_factura`, `fecha_banco`, `detalle`, `nombre_corto`, `tipo_captura`, `descripcion`, `descripcion_detallada`, `id_captura`, `cliente_origen_comision`, `origen_traspaso`, `destino_traspaso`, `id_captura_edo_cta`, `tipo_factura`, `notificado`)


class MovimientoStp
{
  //INSERT INTO `pre_ejecuta_plantilla`(`id`, `plantilla`, `cliente`, `nombre`, `tarjeta`, `clabe`, `institucion`, `monto`, `fecha_creacion`, `fecha_ejecucion`, `status`, `status_banxico`, `id_stp`, `folio`, `estado`, `causa_devolucion`, `time_liquidacion`, `status_pre`, `consulta_cep`, `cep`, `espera_liquidacion`)
  public $id;
  public $plantilla;
  public $cliente;
  public $nombre;
  public $tarjeta;
  public $clabe;
  public $institucion;
  public $monto;
  public $fecha_creacion;
  public $fecha_ejecucion;
  public $status;
  public $status_banxico;
  public $id_stp;
  public $folio;
  public $estado;
  public $causa_devolucion;
  public $time_liquidacion;
  public $status_pre;
  public $consulta_cep;
  public $cep;
  public $espera_liquidacion;
  public $accion;
  public $status_notificado;

  public function __construct($id, $plantilla, $cliente, $nombre, $tarjeta, $clabe, $institucion, $monto, $fecha_creacion, $fecha_ejecucion, $status, $status_banxico, $id_stp, $folio, $estado, $causa_devolucion, $time_liquidacion, $status_pre, $consulta_cep, $cep, $espera_liquidacion)
  {
    $this->id = $id;
    $this->plantilla = $plantilla;
    $this->cliente = $cliente;
    $this->nombre = $nombre;
    $this->tarjeta = $tarjeta;
    $this->clabe = $clabe;
    $this->institucion = $institucion;
    $this->monto = $monto;
    $this->fecha_creacion = $fecha_creacion;
    $this->fecha_ejecucion = $fecha_ejecucion;
    $this->status = $status;
    $this->status_banxico = $status_banxico;
    $this->id_stp = $id_stp;
    $this->folio = $folio;
    $this->estado = $estado;
    $this->causa_devolucion = $causa_devolucion;
    $this->time_liquidacion = $time_liquidacion;
    $this->status_pre = $status_pre;
    $this->consulta_cep = $consulta_cep;
    $this->cep = $cep;
    $this->espera_liquidacion = $espera_liquidacion;
  }
}


class Pago
{
  public $id;
  public $nombre;
  public $monto;
  public $factura;
  public $empresa;
  public $status;
  public $fecha_asignacion;
  public $fecha_operacion;
  public $hora_operacion;
  public $fecha_captura;
  public $tipo_movimiento;
  public $saldo_acreditable;
  public $banco;
  public $saldo;
  public $usuario_registra;
  public $id_factura;
  public $fecha_banco;
  public $detalle;
  public $nombre_corto;
  public $tipo_captura;
  public $descripcion;
  public $descripcion_detallada;
  public $id_captura;
  public $cliente_origen_comision;
  public $origen_traspaso;
  public $destino_traspaso;
  public $id_captura_edo_cta;
  public $tipo_factura;
  public $notificado;
  public $nombreEmpresa;
  public $bancoNombreCorto;
  public $clienteOrigenComisionNombre;
  public $nombreCliente;
  public $clienteAsignado;



  public function __construct($id, $nombre, $monto, $factura, $empresa, $status, $fecha_asignacion, $fecha_operacion, $hora_operacion, $fecha_captura, $tipo_movimiento, $saldo_acreditable, $banco, $saldo, $usuario_registra, $id_factura, $fecha_banco, $detalle, $nombre_corto, $tipo_captura, $descripcion, $descripcion_detallada, $id_captura, $cliente_origen_comision, $origen_traspaso, $destino_traspaso, $id_captura_edo_cta, $tipo_factura, $notificado)
  {
    $this->id = $id;
    $this->nombre = $nombre;
    $this->monto = $monto;
    $this->factura = $factura;
    $this->empresa = $empresa;
    $this->status = $status;
    $this->fecha_asignacion = $fecha_asignacion;
    $this->fecha_operacion = $fecha_operacion;
    $this->hora_operacion = $hora_operacion;
    $this->fecha_captura = $fecha_captura;
    $this->tipo_movimiento = $tipo_movimiento;
    $this->saldo_acreditable = $saldo_acreditable;
    $this->banco = $banco;
    $this->saldo = $saldo;
    $this->usuario_registra = $usuario_registra;
    $this->id_factura = $id_factura;
    $this->fecha_banco = $fecha_banco;
    $this->detalle = $detalle;
    $this->nombre_corto = $nombre_corto;
    $this->tipo_captura = $tipo_captura;
    $this->descripcion = $descripcion;
    $this->descripcion_detallada = $descripcion_detallada;
    $this->id_captura = $id_captura;
    $this->cliente_origen_comision = $cliente_origen_comision;
    $this->origen_traspaso = $origen_traspaso;
    $this->destino_traspaso = $destino_traspaso;
    $this->id_captura_edo_cta = $id_captura_edo_cta;
    $this->tipo_factura = $tipo_factura;
    $this->notificado = $notificado;
  }
}


class CapturaEdo
{
  //SELECT `id`, `id_captura`, `fecha_operacion`, `hora_operacion`, `fecha`, `referencia`, `descripcion`, `cod_transac`, `sucursal`, `deposito`, `retiro`, `saldo`, `movimiento`, `descrip_det`, `cheque`, `referencia_interb`, `tipo_movimiento`, `fecha_sistema`, `asignado`, `cliente_asignado`, `facturado`, `cuenta` FROM `captura_edo_cta` WHERE 1
  public $id;
  public $id_captura;
  public $fecha_operacion;
  public $hora_operacion;
  public $fecha;
  public $referencia;
  public $descripcion;
  public $cod_transac;
  public $sucursal;
  public $deposito;
  public $retiro;
  public $saldo;
  public $movimiento;
  public $descrip_det;
  public $cheque;
  public $referencia_interb;
  public $tipo_movimiento;
  public $fecha_sistema;
  public $asignado;
  public $cliente_asignado;
  public $facturado;
  public $cuenta;

  public function __construct($id, $id_captura, $fecha_operacion, $hora_operacion, $fecha, $referencia, $descripcion, $cod_transac, $sucursal, $deposito, $retiro, $saldo, $movimiento, $descrip_det, $cheque, $referencia_interb, $tipo_movimiento, $fecha_sistema, $asignado, $cliente_asignado, $facturado, $cuenta)
  {
    $this->id = $id;
    $this->id_captura = $id_captura;
    $this->fecha_operacion = $fecha_operacion;
    $this->hora_operacion = $hora_operacion;
    $this->fecha = $fecha;
    $this->referencia = $referencia;
    $this->descripcion = $descripcion;
    $this->cod_transac = $cod_transac;
    $this->sucursal = $sucursal;
    $this->deposito = $deposito;
    $this->retiro = $retiro;
    $this->saldo = $saldo;
    $this->movimiento = $movimiento;
    $this->descrip_det = $descrip_det;
    $this->cheque = $cheque;
    $this->referencia_interb = $referencia_interb;
    $this->tipo_movimiento = $tipo_movimiento;
    $this->fecha_sistema = $fecha_sistema;
    $this->asignado = $asignado;
    $this->cliente_asignado = $cliente_asignado;
    $this->facturado = $facturado;
    $this->cuenta = $cuenta;
  }
}




class AdministradorPagos extends conector
{


  public function fechaComoCadena($fecha)
  {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);

    switch ($mes) {
      case "01":
        $mes = 'Enero';
        break;
      case "02":
        $mes = 'Febrero';
        break;
      case "03":
        $mes = 'Marzo';
        break;
      case  "04":
        $mes = 'Abril';
        break;
      case "05":
        $mes = 'Mayo';
        break;
      case "06":
        $mes = 'Junio';
        break;
      case "07":
        $mes = 'Julio';
        break;
      case "08":
        $mes = 'Agosto';
        break;
      case "09":
        $mes = 'Septiembre';
        break;
      case "10":
        $mes = 'Octubre';
        break;
      case "11":
        $mes = 'Noviembre';
        break;
      case "12":
        $mes = 'Diciembre';
        break;
      default:
        $mes = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
  }

  public function dameCapturasEdo()
  {
    $sql = "SELECT * FROM captura_edo_cta order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new CapturaEdo($fila['id'], $fila['id_captura'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha'], $fila['referencia'], $fila['descripcion'], $fila['cod_transac'], $fila['sucursal'], $fila['deposito'], $fila['retiro'], $fila['saldo'], $fila['movimiento'], $fila['descrip_det'], $fila['cheque'], $fila['referencia_interb'], $fila['tipo_movimiento'], $fila['fecha_sistema'], $fila['asignado'], $fila['cliente_asignado'], $fila['facturado'], $fila['cuenta']);
      array_push($capturas, $captura);
    }
    return $capturas;
  }



  public function insertaTraspaso($monto, $cliente_origen, $cliente_destino, $detalle, $usuario_registra)
  {
    $fecha_captura = date("Y-m-d");
    $hora = date("H:i:s");
    $banco = "Manual";
    $status = "asignado";
    $saldo_recibe = $this->dameSaldoCliente($cliente_destino);
    $saldo_recibe = $saldo_recibe + $monto;
    $saldo_envia = $this->dameSaldoCliente($cliente_origen);
    $saldo_envia = $saldo_envia - $monto;
    $monto_envia_c = -$monto;

    $query_recibe = "INSERT INTO pagos (nombre,monto,factura,empresa,status,fecha_asignacion,fecha_captura,tipo_movimiento,saldo_acreditable,banco,saldo,usuario_registra,fecha_banco,
		detalle,nombre_corto,tipo_captura,descripcion,origen_traspaso,destino_traspaso,cliente_origen_comision) VALUES 
		($cliente_destino,'$monto','NA','99','$status','$fecha_captura','$fecha_captura','Deposito','$monto',99,'$saldo_recibe','$usuario_registra','$fecha_captura',
		'$detalle','99','Manual','Traspaso','$cliente_origen','$cliente_destino','$cliente_origen')";

    $query_envia = "INSERT INTO pagos (nombre,monto,factura,empresa,status,fecha_asignacion,fecha_captura,tipo_movimiento,saldo_acreditable,banco,saldo,usuario_registra,fecha_banco,
		detalle,nombre_corto,tipo_captura,descripcion,origen_traspaso,destino_traspaso,cliente_origen_comision) VALUES 
		($cliente_origen,'$monto_envia_c','NA','99','$status','$fecha_captura','$fecha_captura','Retiro','$monto_envia_c',99,'$saldo_envia','$usuario_registra','$fecha_captura',
		'$detalle','99','Manual','Traspaso','$cliente_origen','$cliente_destino','$cliente_destino')";

    $result_recibe = $this->ejecutar($query_recibe);
    $result_envia = $this->ejecutar($query_envia);
    return 1;
  }


  public function dameSaldoCliente($cliente)
  {
    $sql = "select sum(saldo_acreditable) as suma from pagos where nombre='$cliente'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }


  public function dameReportePorCuenta($cuenta)
  {
    $sql = "SELECT * FROM captura_edo_cta where cuenta='$cuenta' order by id desc";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new CapturaEdo($fila['id'], $fila['id_captura'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha'], $fila['referencia'], $fila['descripcion'], $fila['cod_transac'], $fila['sucursal'], $fila['deposito'], $fila['retiro'], $fila['saldo'], $fila['movimiento'], $fila['descrip_det'], $fila['cheque'], $fila['referencia_interb'], $fila['tipo_movimiento'], $fila['fecha_sistema'], $fila['asignado'], $fila['cliente_asignado'], $fila['facturado'], $fila['cuenta']);
      array_push($capturas, $captura);
    }
    return $capturas;
  }


  public function agregarPago($nombre,  $monto, $factura, $empresa, $status, $fecha_asignacion, $fecha_operacion, $hora_operacion, $fecha_captura, $tipo_movimiento, $saldo_acreditable, $banco, $saldo, $usuario_registra, $id_factura, $fecha_banco, $detalle, $nombre_corto, $tipo_captura, $descripcion, $descripcion_detallada, $id_captura, $cliente_origen_comision, $origen_traspaso, $destino_traspaso, $id_captura_edo_cta, $tipo_factura, $notificado)
  {
    $sql = "INSERT INTO pagos (nombre,  monto, factura, empresa, status, fecha_asignacion, fecha_operacion, hora_operacion, fecha_captura, tipo_movimiento, saldo_acreditable, banco, saldo, usuario_registra, id_factura, fecha_banco, detalle, nombre_corto, tipo_captura, descripcion, descripcion_detallada, id_captura, cliente_origen_comision, origen_traspaso, destino_traspaso, id_captura_edo_cta, tipo_factura, notificado) VALUES ('$nombre',  '$monto', '$factura', '$empresa', '$status', '$fecha_asignacion', '$fecha_operacion', '$hora_operacion', '$fecha_captura', '$tipo_movimiento', '$saldo_acreditable', '$banco', '$saldo', '$usuario_registra', '$id_factura', '$fecha_banco', '$detalle', '$nombre_corto', '$tipo_captura', '$descripcion', '$descripcion_detallada', '$id_captura', '$cliente_origen_comision', '$origen_traspaso', '$destino_traspaso', '$id_captura_edo_cta', '$tipo_factura', '$notificado')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function eliminarPago($id)
  {
    $sql = "DELETE FROM pagos WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function asignarFactura($factura, $id)
  {
    $sql = "UPDATE pagos SET id_factura = '$factura' WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function damePago($id)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa, clientes.nombre as nombre_cliente, pagos.fecha_captura, pagos.fecha_banco, pagos.status
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    inner join clientes on (clientes.id = pagos.nombre)
    where 
    pagos.id='$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
    $pago->nombreEmpresa = $fila['razon'];
    $pago->nombreCliente = $fila['nombre_cliente'];
    return $pago;
  }

  public function damePagos()
  {
    $sql = "SELECT * FROM pagos order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosClienteHoy($cliente)
  {
    $fecha = date("Y-m-d");
    //$fecha = "2023-07-07";
    $sql = "SELECT * FROM pagos where nombre='$cliente' and fecha_asignacion='$fecha' order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function damePagosTraspaso()
  {
    $sql = "SELECT pagos.id,pagos.monto,pagos.detalle,empresas.razon,bancos.nombre_corto,fecha_asignacion,clientes.nombre as cliente_asignado, (SELECT nombre FROM clientes WHERE id=origen_traspaso) AS nomb_origen_traspaso, (SELECT nombre FROM clientes WHERE id=destino_traspaso) AS nomb_destino_traspaso,origen_traspaso,destino_traspaso FROM pagos left join empresas on (empresas.id=pagos.empresa) LEFT JOIN bancos ON (pagos.nombre_corto=bancos.id) left join clientes on (clientes.id=pagos.nombre) where tipo_captura='Manual' and descripcion='Traspaso' and tipo_movimiento='Deposito' limit 10000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreCliente = $fila['nombreCliente'];
      $pago->nombreEmpresa = $fila['nombreEmpresa'];
      $pago->clienteAsignado = $fila['cliente_asignado'];
      $pago->nombreCliente = $fila['nomb_origen_traspaso'];



      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function eliminarTraspaso($id)
  {
    $sql = "DELETE FROM pagos WHERE id='$id'";
    $this->ejecutar($sql);
    $idSec = $id + 1;
    $sql = "DELETE FROM pagos WHERE id='$idSec'";
    $this->ejecutar($sql);
  }

  function damePagosPorCliente($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente' and tipo_movimiento<>'Retiro' and pagos.id_factura=0 and factura='Sin Facturar';";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  function damePagosPorClienteTodo($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente'  and pagos.id_factura=0 and  tipo_movimiento<>'Retiro';";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }


   function damePagosPorClienteEstadoIndex($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle, pagos.tipo_movimiento, pagos.fecha_operacion, pagos.fecha_asignacion,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente' order by pagos.fecha_asignacion desc, pagos.id desc  limit 5;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago(encriptar($fila['id']), $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  function damePagosPorClienteEstado($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle, pagos.tipo_movimiento, pagos.fecha_operacion, pagos.fecha_asignacion,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente' order by pagos.fecha_asignacion desc, pagos.id desc  limit 1000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago(encriptar($fila['id']), $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  function damePagosPorClienteEstadoRetiros($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle, pagos.tipo_movimiento,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente' and pagos.tipo_movimiento='Retiro' limit 1000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago(encriptar($fila['id']), $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  function damePagosPorClienteEstadoDeposito($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle, pagos.tipo_movimiento,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente' and pagos.tipo_movimiento='Deposito' limit 1000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago(encriptar($fila['id']), $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }



  public function dameReporte($cliente, $fecha, $fecha_mes)
  {
    $sql = "select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.* from pagos 
    left join clientes on (clientes.id=pagos.cliente_origen_comision)
    left join captura on (captura.id=pagos.id_captura)
    left join bancos on (bancos.id=captura.nombre_corto)
    LEFT JOIN empresas ON (empresas.id=captura.razon) 
    where pagos.nombre='$cliente' and saldo_acreditable<>0
    and fecha_asignacion>='$fecha_mes' and fecha_asignacion<='$fecha'
    order by fecha_asignacion ASC";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], "$" . number_format($fila['monto'], 2), $fila['factura'], $fila['empresa'], $fila['status'], $this->fechaComoCadena($fila['fecha_asignacion']), $this->fechaComoCadena($fila['fecha_operacion']), $fila['hora_operacion'], $this->fechaComoCadena($fila['fecha_captura']), $fila['tipo_movimiento'], "$" . number_format($fila['saldo_acreditable']), $fila['banco'], "$" . number_format($fila['saldo'], 2), $fila['usuario_registra'], $fila['id_factura'], $this->fechaComoCadena($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      $pago->bancoNombreCorto = $fila['nombre_corto_b'];
      $pago->clienteOrigenComisionNombre = $fila['cliente_origen'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function cuentaPagos()
  {
    $sql = "SELECT COUNT(*) AS total FROM pagos";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function cuentaPagosAsignados()
  {
    $sql = "SELECT COUNT(*) AS total FROM pagos WHERE nombre != null or nombre != ''";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function damePagosAsignados()
  {
    $sql = "SELECT * FROM pagos WHERE nombre != null or nombre != '' order by id desc limit 10000";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function cuentaPagosSinAsignar()
  {
    $sql = "SELECT COUNT(*) AS total FROM pagos WHERE nombre = null or nombre = ''";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function damePagosSinAsignar()
  {
    $sql = "SELECT * FROM pagos WHERE status <>'asignado' order by id desc limit 10000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function dameMovimientosStp()
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente order by id desc limit 10000";
    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);

      if ($fila['cep'] != null && $fila['cep'] != '') {
        $movimiento->accion = '
        <a href="' . $fila['cep'] . '" target="_blanck"> <div class="circle long">
        <img src="media/banjico.png" alt="..." class="img-thumbnail" style="height: 20px;">
      </div> </a>
        
        ';
      } else {
        $movimiento->accion = 'No Valido';
      }


      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

  public function dameMovimientosDiaCuenta($numero, $cliente)
  {
    $hoy = date("Y-m-d");
    $sql = "
    SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente 
    where (pre_ejecuta_plantilla.clabe = '$numero' or pre_ejecuta_plantilla.tarjeta = '$numero') and fecha_creacion like '$hoy%' order by id desc";
    $result = $this->ejecutar($sql);
    // and pre_ejecuta_plantilla.cliente = $cliente
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

  public function dameMovimientosStpCliente($cliente)
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM pre_ejecuta_plantilla
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente where pre_ejecuta_plantilla.cliente = $cliente order by id desc limit 100";
    $result = $this->ejecutar($sql);
    //echo $sql;
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp(encriptar($fila['id']), $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      $movimiento->status_notificado = $fila['status_notificado'];
      if ($fila['cep'] != null && $fila['cep'] != '') {
        $movimiento->accion = '
        <a href="' . $fila['cep'] . '" target="_blanck"> <div class="circle long">
        <img src="media/banjico.png" alt="..." class="img-thumbnail" style="height: 20px;">
      </div> </a>
        
        ';
      } else {
        $movimiento->accion = 'No Valido';
      }


      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

    public function dameMovimientosStpClienteUltimos5($cliente)
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM pre_ejecuta_plantilla
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente where pre_ejecuta_plantilla.cliente = $cliente order by id desc limit 5";
    $result = $this->ejecutar($sql);
    //echo $sql;
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp(encriptar($fila['id']), $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      $movimiento->status_notificado = $fila['status_notificado'];
      if ($fila['cep'] != null && $fila['cep'] != '') {
        $movimiento->accion = '
        <a href="' . $fila['cep'] . '" target="_blanck"> <div class="circle long">
        <img src="media/banjico.png" alt="..." class="img-thumbnail" style="height: 20px;">
      </div> </a>
        
        ';
      } else {
        $movimiento->accion = 'No Valido';
      }


      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

    public function dameUlitimoMovimientosStpCliente($cliente)
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM pre_ejecuta_plantilla
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente where pre_ejecuta_plantilla.cliente = $cliente order by id desc limit 1";
    $result = $this->ejecutar($sql);
    //echo $sql;
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp(($fila['id']), $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      $movimiento->status_notificado = $fila['status_notificado'];
      if ($fila['cep'] != null && $fila['cep'] != '') {
        $movimiento->accion = '
        <a href="' . $fila['cep'] . '" target="_blanck"> <div class="circle long">
        <img src="media/banjico.png" alt="..." class="img-thumbnail" style="height: 20px;">
      </div> </a>
        
        ';
      } else {
        $movimiento->accion = 'No Valido';
      }


      
    }
    return $movimiento;
  }

  public function dameMovimientoStp($id)
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente where pre_ejecuta_plantilla.id='$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
    return $movimiento;
  }

  public function dameMovmientosStpCliente($cliente)
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente where pre_ejecuta_plantilla.cliente='$cliente' order by id desc limit 10000";
    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }
  public function dameMovmientosStpClientePendientes($cliente)
  {
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
    inner join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente where pre_ejecuta_plantilla.cliente='$cliente' and  order by id desc limit 10000";
    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }


  public function seUsoEstaSemana($cuenta)
  {
    $hoy = date('Y-m-d');
    $lunesAnterior = date("Y-m-d", strtotime("last monday"));
    $sql = "SELECT * FROM `pre_ejecuta_plantilla` where fecha_creacion>='$lunesAnterior 00:00:00' and fecha_creacion<='$hoy 23:00:00' and (clabe = '$cuenta' or tarjeta = '$cuenta')";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }
}
