<?php

include 'conectorBDS14.php';


class Movimiento {
    public $id;
    public $nombre;
    public $targeta;
    public $monto;
    public $banco;
	public $tipo;
	public $cat_id_banco;

    public function __construct($id, $nombre, $targeta, $monto, $banco, $tipo, $cat_id_banco) {
        $this->id = $id;
        $this->nombre = $nombre;
        $this->targeta = $targeta;
        $this->monto = $monto;
        $this->banco = $banco;
		$this->tipo = $tipo;
		$this->cat_id_banco = $cat_id_banco;
    }
}


function dameBancoCat($nombre){
	$conector = new conector();
	$sql = "SELECT * FROM `stp_cat_bancos` WHERE `razon_social_completa` LIKE '%".$nombre."%'";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['cve_id'];
}

function procesarArchivoCSV($archivo) {
    $movimientos = array();
    $fila = 0;

    if (($gestor = fopen($archivo['tmp_name'], 'r')) !== false) {
        while (($datos = fgetcsv($gestor, 1000, ',')) !== false) {
			$comprovante = "DATA ". $datos[0];
			if(strpos($comprovante, 'NOMBRE') !== false){
				$saltar = true;
			}
			else{
				$saltar = false;
			}

            if (!$saltar) { // Saltar la primera fila (encabezado)
                $id = $fila;
                $nombre = $datos[0];
                $targeta = $datos[1];
                $monto = $datos[2];
				$targeta = str_replace(' ', '', $targeta);
				$targeta = str_replace('-', '', $targeta);
				$targeta = str_replace('X', '', $targeta);
				$targeta = str_replace('x', '', $targeta);
				$targeta = str_replace('.', '', $targeta);
				$monto = str_replace('$', '', $monto);
				$monto = str_replace(',', '', $monto);
				$monto = str_replace(' ', '', $monto);
                $banco = determinaBanco($targeta);
				$nombrebanco = $banco->bank->name;
				$idBancoCat = dameBancoCat($nombrebanco);


				//contar digitos targeta 
				$digitos = strlen($targeta);

				//determinar tipo de targeta
				if($digitos == 16){
					$tipo = "TARGETA";
				}
				else if($digitos == 18){
					$tipo = "CUENTA";
				}
				else{
					$tipo = "OTRO";
				}

                $movimiento = new Movimiento($id, $nombre, $targeta, $monto, $banco, $tipo, $idBancoCat);
                $movimientos[] = $movimiento;
            }
            $fila++;
        }
        fclose($gestor);
    }

    return $movimientos;
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["file"])) {
    $movimientos = procesarArchivoCSV($_FILES["file"]);

    // Ahora puedes hacer lo que necesites con el arreglo de movimientos
    echo json_encode($movimientos);
}


/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code has been removed, and the file is now safe to use.
*/


?>