<?php
// Cargar la librería PHPExcel
require_once 'PHPExcel/Classes/PHPExcel.php';

// Ruta del archivo XLS que quieres leer
include_once 'conectorBDS14.php';
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);

$cuentasDispersas = array();

class Movimiento
{
	public $id;
	public $nombre;
	public $targeta;
	public $monto;
	public $banco;
	public $tipo;
	public $cat_id_banco;
	public $error;
	public $telefono;

	public function __construct($id, $nombre, $targeta, $monto, $banco, $tipo, $cat_id_banco, $error)
	{
		$this->id = $id;
		$this->nombre = $nombre;
		$this->targeta = $targeta;
		$this->monto = $monto;
		$this->banco = $banco;
		$this->tipo = $tipo;
		$this->cat_id_banco = $cat_id_banco;
		$this->error = $error;
	}
}


function agregarCuenta($cuenta, $monto) {
    global $cuentasDispersas;

    if (!isset($cuentasDispersas[$cuenta])) {
        // Si no existe, se crea con el monto inicial
        $cuentasDispersas[$cuenta] = $monto;
    } else {
        // Si ya existe, se suma el nuevo monto
        $cuentasDispersas[$cuenta] += $monto;
    }

    // Retorna verdadero si el saldo es mayor a 80000
    return $cuentasDispersas[$cuenta] > 80000;
}

function contieneCaracreresEspeciales($cadena){
	$caracteresEspeciales = array('á', 'é', 'í', 'ó', 'ú', 'ñ', 'Á', 'É', 'Í', 'Ó', 'Ú', 'Ñ', '.', ',', ';', ':', '!', '?', '¿', '¡', '(', ')', '[', ']', '{', '}', '<', '>', '&', '%', '$', '#', '@', '|', '\\', '/', '=', '+', '*', '~', '`', '^', '"', "'", '°', '¬', '¦', '¢', '£', '¤', '¥', '¦', '§', '¨', '©', 'ª', '«', '¬', '®', '¯', '°', '±', '²', '³', '´', 'µ', '¶', '·', '¸', '¹', 'º', '»', '¼', '½', '¾', '¿', 'À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', '×', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'Þ', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ð', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', '÷', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'þ', 'ÿ');
	$contieneCaracteresEspeciales = false;
	foreach ($caracteresEspeciales as $caracterEspecial) {
		if (strpos($cadena, $caracterEspecial) !== false) {
			$contieneCaracteresEspeciales = true;
			break;
		}
	}
	return $contieneCaracteresEspeciales;
}

function eliminarEspaciosAlFinal($cadena)
{
	// Utilizamos la función rtrim para eliminar espacios en blanco al final de la cadena
	$cadenaSinEspacios = rtrim($cadena);

	// Comparamos la cadena original con la cadena sin espacios para determinar si había espacios al final
	if ($cadena !== $cadenaSinEspacios) {
		$espaciosEliminados = strlen($cadena) - strlen($cadenaSinEspacios);
		// echo "Se han eliminado $espaciosEliminados espacio(s) al final de la cadena.<br>";
	} else {
		//echo "No se encontraron espacios al final de la cadena.<br>";
	}

	// Retornamos la cadena sin espacios al final
	return $cadenaSinEspacios;
}


function dameBancoCat($nombre)
{
	$conector = new conector();
	$sql = "SELECT * FROM `stp_cat_bancos` WHERE `razon_social_completa` LIKE '%" . $nombre . "%'";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['cve_id'];
}

function dameNombreBanco($clave)
{
	$conector = new conector();
	$sql = "SELECT * FROM `stp_cat_bancos` WHERE `cve_id` LIKE '%" . $clave . "%'";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['nombre_corto'];
}

function dameSaldoStp()
{
	$conector = new conector();
	$sql = "SELECT * FROM `stp_saldos` ORDER BY id DESC limit 1;";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['saldo'];
}

function limpiaNombre($nombre)
{
	$nombre = str_replace('ñ', 'n', $nombre);
	$nombre = str_replace('Ñ', 'N', $nombre);
	$nombre = str_replace('á', 'a', $nombre);
	$nombre = str_replace('Á', 'A', $nombre);
	$nombre = str_replace('é', 'e', $nombre);
	$nombre = str_replace('É', 'E', $nombre);
	$nombre = str_replace('í', 'i', $nombre);
	$nombre = str_replace('Í', 'I', $nombre);
	$nombre = str_replace('ó', 'o', $nombre);
	$nombre = str_replace('Ó', 'O', $nombre);
	$nombre = str_replace('ú', 'u', $nombre);
	$nombre = str_replace('Ú', 'U', $nombre);
	$nombre = str_replace('ü', 'u', $nombre);
	$nombre = str_replace('Ü', 'U', $nombre);
	return $nombre;
}

function determinaBanco($targeta)
{

	$primeros = substr($targeta, 0, 6);
	$curl = curl_init();

	curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://old.sistema14.com/plus/sistema/api/getBanco.php?numero=' . $primeros . '&llave=sistema14AdminKeySuc',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'GET',
		CURLOPT_HTTPHEADER => array(
			'Accept-Version: 3'
		),
	));

	$response = curl_exec($curl);

	curl_close($curl);
	return json_decode($response);
}

function procesarXls($filePath)
{

	$saldo = $_POST['saldo'];
	$saldoStp = dameSaldoStp();
	try {
		// Cargar el archivo .xls
		$excelReader = PHPExcel_IOFactory::createReaderForFile($filePath);
		$excelObj = $excelReader->load($filePath);
		$movimientos = array();

		// Obtener la primera hoja
		$sheet = $excelObj->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		// Leer fila por fila
		for ($row = 1; $row <= $highestRow; $row++) {
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
			//nombre pos 0 
			if ($row > 1) {
				$id = $row - 1;
				$error = "Correcto";

				$nombre = $rowData[0][0];
				$targeta = $rowData[0][1];
				$monto = $rowData[0][2];
				$telefono = $rowData[0][3];

				$medidaNombre = strlen($nombre);
				$telefono = str_replace(' ', '', $telefono);
				$telefono = str_replace('-', '', $telefono);
				$targeta = str_replace(' ', '', $targeta);
				$targeta = str_replace('-', '', $targeta);
				$targeta = str_replace('X', '', $targeta);
				$targeta = str_replace('x', '', $targeta);
				$targeta = str_replace('.', '', $targeta);
				$targeta = eliminarEspaciosAlFinal($targeta);
				$digitos = strlen($targeta);

				$monto = str_replace('$', '', $monto);
				$monto = str_replace(',', '', $monto);
				$monto = str_replace(' ', '', $monto);

				if ($digitos == 16) {
					$banco = determinaBanco($targeta);
				} else if ($digitos == 18) {
					$banco = new stdClass(); // Crear un objeto vacío para representar $banco
					$banco->bank = new stdClass(); // Crear un objeto vacío para representar $banco->bank
					$primeros_tres_digitos = substr($targeta, 0, 3); //extrae los primeros 3 digitos
					$banco->bank->name = dameNombreBanco($primeros_tres_digitos); // Asignar un valor a $banco->bank->name
				}
				$nombrebanco = $banco->bank->name;
				$idBancoCat = dameBancoCat($nombrebanco);


				//contar digitos targeta 
				$damanioNombre = strlen($nombre);
				$saldo = $saldo - $monto;
				$saldoStp = $saldoStp - $monto;
				if ($saldoStp < 0) {
					$error = "Correcto";
				}
				if ($saldo < 0) {
					$error = "Saldo cliente insuficiente";
				}

			
				//determinar tipo de targeta
				if ($banco == null || $banco->bank->name == null) {
					$error = "Banco no reconocido";
				}
				if ($digitos == 16) {
					$tipo = "TARJETA";
				} else if ($digitos == 18) {
					$tipo = "CUENTA";
				} else {
					$tipo = "OTRO";
					$error = "Targeta o clave incorrecta (Digitos: " . $digitos . " no validos)";
				}
				if ($damanioNombre < 1) {
					$error = "Nombre no valido";
				}
				if ($monto <= 0) {
					$error = "Monto no valido";
				}
				if ($monto > 50000.1) {
					$error = "Monto excede limite de $50,000";
				}
				if ($medidaNombre < 1) {
					$error = "Nombre no valido (vacio)";
				}
				if ($medidaNombre > 40) {
					$error = "Nombre no valido (mayor a 40 caracteres)";
				}
				if(contieneCaracreresEspeciales($nombre)){
					$nombre = limpiaNombre($nombre);
					$error = "Corregido";
				}

				if(agregarCuenta($targeta, $monto)){
					$error = "La suma de sus movimientos excede el limite de $80,000 para esta cuenta";
				}
				$movimiento = new Movimiento($id, $nombre, $targeta, $monto, $banco, $tipo, $idBancoCat, $error);
				$movimiento->telefono = $telefono;
				$movimientos[] = $movimiento;

			}
		}
		echo json_encode($movimientos);

	} catch (Exception $e) {
		die('Error al cargar el archivo: ' . $e->getMessage());
	}
}


$hoyDiaHora = date("Y-m-d H:i:s");

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
	$documentRoot = $_SERVER['DOCUMENT_ROOT'];
	$targetDir = $documentRoot . '/docs/'; // Directorio donde se almacenarán los archivos subidos
	$targetFile = $targetDir . basename($_FILES['file']['name']);

	$fileType = pathinfo($targetFile, PATHINFO_EXTENSION);

	// Comprobar si el archivo es realmente un archivo XLS
	if ($fileType !== 'xls' && $fileType !== 'xlsx') {
		echo "Solo se permiten archivos XLS o XLSX.";
		exit;
	}

	// Mover el archivo subido al directorio destino
	if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
		procesarXls($targetFile);

		// Eliminar el archivo subido después de su procesamiento si es necesario
		// unlink($targetFile);
	} else {
		echo "Ocurrió un error al subir el archivo.";
	}
}
