<!DOCTYPE html>
<html lang="en">

<head>
     <!-- Title Meta -->
     <meta charset="utf-8" />
     <title>Banca14 DEV</title>
     <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <meta name="description" content="Banca14: Dispersion y gestión de pagos." />
     <meta name="author" content="StackBros" />
     <meta name="keywords" content="Banca14" />
     <meta http-equiv="X-UA-Compatible" content="IE=edge" />
     <meta name="robots" content="index, follow" />
     <meta name="theme-color" content="#ffffff">

     <!-- App favicon -->
     <link rel="shortcut icon" href="assets/images/favicon.ico">
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

     <!-- Google Font Family link -->
     <link rel="preconnect" href="https://fonts.googleapis.com">
     <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
     <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

     <!-- Vendor css -->
     <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

     <!-- Icons css -->
     <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

     <!-- App css -->
     <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

     <!-- Theme Config js -->
     <script src="assets/js/config.js"></script>


     <link href="assets/css/index.css" rel="stylesheet" type="text/css" />

</head>

<body>

     <?php
     session_start();
     include_once "../funciones.php";
     $con = conectar();
     include "api/adminStrikes.php";
     include_once "api/doxeador.php";
     include_once "api/encriptador.php";
     include_once "api/validadorPermisos.php";
     include_once "api/adminPagos.php";

     //include_once "api/adminPagos.php";

     //$doxeo = dameDoxeo();
     $adminStrikes = new AdministradorStrikes();
     //$adminPagos = new AdministradorPagos();
     $adminPagos = new AdministradorPagos();
     $pagosIndex = $adminPagos->damePagosPorClienteEstadoIndex($_SESSION['clientes_sistema_14_cliente']);
     $ultimoPagoStp = $adminPagos->dameUlitimoMovimientosStpCliente($_SESSION["clientes_sistema_14_cliente"]);

     $ultimoPago = $ultimoPagoStp;
     $cantidadStrikes = $adminStrikes->cuentaStrikes($_SESSION['clientes_sistema_14_id']);



     $cliente_nombre = $_SESSION["clientes_sistema_14_nombre"];
     $id_cliente = $_SESSION["clientes_sistema_14_cliente"];
     $saldo = mysql_este("select sum(saldo_acreditable) as suma from pagos where nombre='$id_cliente'", "suma", $con);
     //echo $_SESSION["clientes_sistema_14_cliente_key"];
     include_once("../plus/clientes/api/adminClientes.php");
     $adminClientes = new AdministradorClientes();
     $cliente = $adminClientes->dameCliente($_SESSION['clientes_sistema_14_cliente']);

     if (floatval($saldo) > 0) {
          //que se vea pero no se pueda seleccionar 
          $linkTrastraspaso = "traspaso.php";
          $cadenaTraspaso = "Traspaso 14";
     } else {
          $linkTrastraspaso = "#";
          //$linkTrastraspaso = "traspaso.php";

          $cadenaTraspaso = "(SIN SALDO)";
     }


     ?>


     <?php
     function formatearFechaEsp($fecha)
     {
          // Aseguramos que se maneje correctamente la fecha
          $timestamp = strtotime($fecha);

          // Días y meses en español
          $dias = [
               "Domingo",
               "Lunes",
               "Martes",
               "Miércoles",
               "Jueves",
               "Viernes",
               "Sábado"
          ];
          $meses = [
               "Enero",
               "Febrero",
               "Marzo",
               "Abril",
               "Mayo",
               "Junio",
               "Julio",
               "Agosto",
               "Septiembre",
               "Octubre",
               "Noviembre",
               "Diciembre"
          ];

          // Obtenemos los componentes
          $diaSemana = $dias[date("w", $timestamp)];
          $dia = date("d", $timestamp);
          $mes = $meses[date("n", $timestamp) - 1];
          $anio = date("Y", $timestamp);

          // Retornamos en el formato solicitado
          return "$diaSemana, $dia/$mes/$anio";
     }

     ?>



     <!-- START Wrapper -->
     <div class="app-wrapper">
          <!-- Topbar Start -->
          <?php include_once 'template/header.php'; ?>
          <!-- Topbar End -->

          <!-- App Menu Start -->
          <?php include_once 'template/barra.php'; ?>
          <!-- App Menu End -->

          <!-- ==================================================== -->
          <!-- Start right Content here -->
          <!-- ==================================================== -->
          <div class="" style="padding: 1rem;">

               <!-- Start Container Fluid -->
               <div class="container-fluid">

                    <!-- ========== Page Title Start ========== -->
                    <div class="row">
                         <div class="col-12">
                              <div class="page-title-box">
                                   <h4 class="mb-0">Inicio Banca</h4>
                                   <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
                                        <li class="breadcrumb-item active">Inicio Banca</li>
                                   </ol>
                              </div>
                         </div>
                    </div>
                    <!-- ========== Page Title End ========== -->

                    <div class="row">









                         <!-- Card 1 -->
                         <div class="col-md-12 col-xl-12">
                              <div class="card" style="background-color: #bfbfbf;">
                                   <div class="card-body">
                                        <div class="row">
                                             <div class="col-6">
                                                  <div class="">
                                                       <div class="bajorrelieve"><?= strtoupper($cliente_nombre) ?></div>


                                                  </div>
                                             </div>
                                             <div class="col-6 text-end">
                                                  <p class="text-muted mb-0 text-truncate">Saldo de la cuenta</p>
                                                  <h3 class="text-dark mt-2 mb-0">$<?= number_format($saldo, 2) ?></h3>
                                             </div>
                                        </div>
                                   </div>

                              </div>
                         </div>

                    </div>




                    <div class="row">




                         <div class="parent">
                              <div class="div1" style="display: flex; justify-content: center;">
                                   <div class="col-xl-3 col-md-12 col-sm-4 col-12 mb-4" style="display: flex; justify-content: center;">
                                        <div style="display: flex; flex-direction: column; align-items: center; padding-top: 1rem;">
                                             <a href="retiro.php" style="text-decoration: none;">
                                                  <button type="button" class="s14-rotbtn">
                                                       <p class="s14-rotbtn__text">
                                                            <span style="--index: 0;">R</span>
                                                            <span style="--index: 1;">E</span>
                                                            <span style="--index: 2;">T</span>
                                                            <span style="--index: 3;">I</span>
                                                            <span style="--index: 4;">R</span>
                                                            <span style="--index: 5;">A</span>
                                                            <span style="--index: 6;">R</span>
                                                       </p>

                                                       <div class="s14-rotbtn__circle">
                                                            <svg
                                                                 viewBox="0 0 14 15"
                                                                 fill="none"
                                                                 xmlns="http://www.w3.org/2000/svg"
                                                                 class="s14-rotbtn__icon"
                                                                 width="14">
                                                                 <path
                                                                      d="M13.376 11.552l-.264-10.44-10.44-.24.024 2.28 6.96-.048L.2 12.56l1.488 1.488 9.432-9.432-.048 6.912 2.304.024z"
                                                                      fill="currentColor" />
                                                            </svg>

                                                            <svg
                                                                 viewBox="0 0 14 15"
                                                                 fill="none"
                                                                 width="14"
                                                                 xmlns="http://www.w3.org/2000/svg"
                                                                 class="s14-rotbtn__icon s14-rotbtn__icon--copy">
                                                                 <path
                                                                      d="M13.376 11.552l-.264-10.44-10.44-.24.024 2.28 6.96-.048L.2 12.56l1.488 1.488 9.432-9.432-.048 6.912 2.304.024z"
                                                                      fill="currentColor" />
                                                            </svg>
                                                       </div>
                                                  </button>
                                             </a>

                                             <!-- Texto debajo del botón -->
                                             <h3 style="padding-top: 1rem; margin-top: 1rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.3);">
                                                  OPERACIONES
                                             </h3>
                                        </div>

                                   </div>
                              </div>
                              <div class="div2">
                                   <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                        <a href="contactos.php">


                                             <!-- From Uiverse.io by vinodjangid07 -->
                                             <button class="Btn" style="background-color: #0096FF;">
                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 21a9 9 0 1 0 0-18 9 9 0 0 0 0 18Zm0 0a8.949 8.949 0 0 0 4.951-1.488A3.987 3.987 0 0 0 13 16h-2a3.987 3.987 0 0 0-3.951 3.512A8.948 8.948 0 0 0 12 21Zm3-11a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Contactos</div>
                                             </button>





                                        </a>
                                   </div>

                                   <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                        <a href="movimientos.php">
                                             <button class="Btn" style="background-color: #FFBF00;">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3M3.22302 14C4.13247 18.008 7.71683 21 12 21c4.9706 0 9-4.0294 9-9 0-4.97056-4.0294-9-9-9-3.72916 0-6.92858 2.26806-8.29409 5.5M7 9H3V5" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Movimientos</div>
                                             </button>
                                        </a>
                                   </div>


                                   <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                        <a href="comprobantes.php">

                                             <button class="Btn">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 17v-5h1.5a1.5 1.5 0 1 1 0 3H5m12 2v-5h2m-2 3h2M5 10V7.914a1 1 0 0 1 .293-.707l3.914-3.914A1 1 0 0 1 9.914 3H18a1 1 0 0 1 1 1v6M5 19v1a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-1M10 3v4a1 1 0 0 1-1 1H5m6 4v5h1.375A1.627 1.627 0 0 0 14 15.375v-1.75A1.627 1.627 0 0 0 12.375 12H11Z" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Comprobantes</div>
                                             </button>
                                        </a>
                                   </div>

                                   <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                        <a href="plantilla.php">
                                             <button class="Btn" style="background-color: #4CBB17;">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 10V4a1 1 0 0 0-1-1H9.914a1 1 0 0 0-.707.293L5.293 7.207A1 1 0 0 0 5 7.914V20a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2M10 3v4a1 1 0 0 1-1 1H5m5 6h9m0 0-2-2m2 2-2 2" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Plantillas</div>
                                             </button>
                                        </a>
                                   </div>
                              </div>
                              <div class="div3" style="padding-right: 1rem;">
                                   <div class="cardEsp">
                                        <?php

                                        $cadenaMovimiento = "Retiro";
                                        $flechaMovimiento = "fa-arrow-up";
                                        $colorIcono = "icon-color-red";
                                        $qrMov = "https://ultra.sistema14.com/api/qrcodes/comprobante" . $ultimoPago->id . ".png";
                                        ?>
                                        <img src="<?= $qrMov ?>" alt="Foto de identificación" style="object-fit: contain;">
                                        <div class="datos">
                                             <div class="dato" style="font-weight: bold;">Ultimo comprobante</div>
                                             <div class="dato"><?= $cadenaMovimiento ?>: $ <?= number_format($ultimoPago->monto, 2) ?></div>
                                             <div class="dato">Retiro banca 14, Referencia <?= $ultimoPago->folio ?></div>
                                             <div class="dato"><?= formatearFechaEsp($ultimoPago->fecha_creacion)  ?></div>
                                        </div>
                                   </div>
                              </div>

                              <div class="div7">

                                   <h3 style="  text-shadow: 2px 2px 4px rgba(0,0,0,0.3);">Últimos movimientos</h3>
                                   <div class="row">



                                        <?php

                                        foreach ($pagosIndex as $pago) {
                                             if ($pago->tipo_movimiento == "Deposito") {
                                                  $cadenaMovimiento = "Depósito";
                                                  $flechaMovimiento = "fa-arrow-down";
                                                  $colorIcono = "icon-color-green";
                                             } else if ($pago->tipo_movimiento == "Retiro") {
                                                  $cadenaMovimiento = "Retiro";
                                                  $flechaMovimiento = "fa-arrow-up";
                                                  $colorIcono = "icon-color-red";
                                             }


                                        ?>



                                             <div class="col-sm-12">
                                                  <div class="card card-body position-relative retiro-card">

                                                       <!-- Etiqueta vertical como en la imagen -->
                                                       <small class="retiro-label"><?= $cadenaMovimiento ?></small>

                                                       <!-- Contenido principal -->
                                                       <div class="d-flex align-items-start justify-content-start">
                                                            <span class="icon-big <?= $colorIcono ?>">
                                                                 <i class="fa <?= $flechaMovimiento ?>"></i>
                                                            </span>

                                                            <div style="width: 90% !important;">
                                                                 <p class="mb-1 truncate-text">
                                                                      <?= $pago->descripcion ?>
                                                                 </p>
                                                                 <div class="d-flex justify-content-between align-items-end">
                                                                      <p class="mb-0">
                                                                           <span class="text-muted"></span>
                                                                           <span style="font-style: italic; font-size: 0.7rem;"><?= formatearFechaEsp($pago->fecha_asignacion) ?></span>
                                                                      </p>
                                                                      <p class="mb-0 fw-bold" style="font-size:1.1rem; ">$<?= number_format($pago->saldo_acreditable, 2) ?></p>
                                                                 </div>
                                                            </div>
                                                       </div>

                                                  </div>
                                             </div>
                                        <?php
                                        }
                                        ?>

                                   </div>

                              </div>


                         </div>



                         <div style="display: none;">
                              <div class="col-xl-3 col-md-12 col-sm-4 col-12 mb-4">
                                   <a href="retiro.php">
                                        <div class=" mb-3 mb-xl-0" style="align-items: center; padding-top: 18px; height: 150px; left: 35%; position: relative;">
                                             <button type="button" class="s14-rotbtn">
                                                  <p class="s14-rotbtn__text">
                                                       <span style="--index: 0;">R</span>
                                                       <span style="--index: 1;">E</span>
                                                       <span style="--index: 2;">T</span>
                                                       <span style="--index: 3;">I</span>
                                                       <span style="--index: 4;">R</span>
                                                       <span style="--index: 5;">A</span>
                                                       <span style="--index: 6;">R</span>
                                                       <!-- <span style="--index: 7;"> </span>
                                                  <span style="--index: 8;">C</span>
                                                  <span style="--index: 9;">S</span>
                                                  <span style="--index: 10;">S</span>
                                                  <span style="--index: 11;"> </span>
                                                  <span style="--index: 12;">B</span>
                                                  <span style="--index: 13;">U</span>
                                                  <span style="--index: 14;">T</span>
                                                  <span style="--index: 15;">T</span>
                                                  <span style="--index: 16;">O</span>
                                                  <span style="--index: 17;">N</span> -->
                                                  </p>

                                                  <div class="s14-rotbtn__circle">
                                                       <svg
                                                            viewBox="0 0 14 15"
                                                            fill="none"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                            class="s14-rotbtn__icon"
                                                            width="14">
                                                            <path
                                                                 d="M13.376 11.552l-.264-10.44-10.44-.24.024 2.28 6.96-.048L.2 12.56l1.488 1.488 9.432-9.432-.048 6.912 2.304.024z"
                                                                 fill="currentColor" />
                                                       </svg>

                                                       <svg
                                                            viewBox="0 0 14 15"
                                                            fill="none"
                                                            width="14"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                            class="s14-rotbtn__icon s14-rotbtn__icon--copy">
                                                            <path
                                                                 d="M13.376 11.552l-.264-10.44-10.44-.24.024 2.28 6.96-.048L.2 12.56l1.488 1.488 9.432-9.432-.048 6.912 2.304.024z"
                                                                 fill="currentColor" />
                                                       </svg>
                                                  </div>
                                             </button>

                                        </div> <!-- end card -->
                                   </a>
                              </div>








                              <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                   <a href="contactos.php">
                                        <div class=" mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px; left: 35%; position: relative;">


                                             <!-- From Uiverse.io by vinodjangid07 -->
                                             <button class="Btn">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 21a9 9 0 1 0 0-18 9 9 0 0 0 0 18Zm0 0a8.949 8.949 0 0 0 4.951-1.488A3.987 3.987 0 0 0 13 16h-2a3.987 3.987 0 0 0-3.951 3.512A8.948 8.948 0 0 0 12 21Zm3-11a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Contactos</div>
                                             </button>





                                        </div> <!-- end card -->
                                   </a>
                              </div>
                              <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                   <a href="movimientos.php">
                                        <div class=" mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px; left: 35%; position: relative;">
                                             <button class="Btn">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3M3.22302 14C4.13247 18.008 7.71683 21 12 21c4.9706 0 9-4.0294 9-9 0-4.97056-4.0294-9-9-9-3.72916 0-6.92858 2.26806-8.29409 5.5M7 9H3V5" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Movimientos</div>
                                             </button>
                                        </div> <!-- end card -->
                                   </a>
                              </div>

                              <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                   <a href="comprobantes.php">

                                        <div class=" mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px; left: 35%; position: relative;">
                                             <button class="Btn">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 17v-5h1.5a1.5 1.5 0 1 1 0 3H5m12 2v-5h2m-2 3h2M5 10V7.914a1 1 0 0 1 .293-.707l3.914-3.914A1 1 0 0 1 9.914 3H18a1 1 0 0 1 1 1v6M5 19v1a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-1M10 3v4a1 1 0 0 1-1 1H5m6 4v5h1.375A1.627 1.627 0 0 0 14 15.375v-1.75A1.627 1.627 0 0 0 12.375 12H11Z" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Comprobantes</div>
                                             </button>
                                        </div> <!-- end card -->
                                   </a>
                              </div>

                              <div class="col-xl-2 col-md-12 col-sm-4 col-12 mb-3">
                                   <a href="plantilla.php">
                                        <div class=" mb-3 mb-xl-0" style="align-items: center; padding: 40px;     height: 150px; left: 35%; position: relative;">
                                             <button class="Btn">

                                                  <div class="sign">
                                                       <svg style="width: 300px" class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 10V4a1 1 0 0 0-1-1H9.914a1 1 0 0 0-.707.293L5.293 7.207A1 1 0 0 0 5 7.914V20a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2M10 3v4a1 1 0 0 1-1 1H5m5 6h9m0 0-2-2m2 2-2 2" />
                                                       </svg>
                                                  </div>

                                                  <div class="text">Plantillas</div>
                                             </button>
                                        </div> <!-- end card -->
                                   </a>
                              </div>

                         </div>


                    </div> <!-- end row -->




               </div>
               <!-- End Container Fluid -->

               <!-- Footer Start -->
               <?php include_once 'template/footer.php'; ?>

               <!-- Footer End -->

          </div>
          <!-- ==================================================== -->
          <!-- End Page Content -->
          <!-- ==================================================== -->

     </div>
     <!-- END Wrapper -->

     <!-- Vendor Javascript -->
     <script src="assets/js/vendor.min.js"></script>

     <!-- App Javascript -->
     <script src="assets/js/app.js"></script>

     <!-- Vector Map Js -->
     <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
     <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
     <script src="assets/vendor/jsvectormap/maps/world.js"></script>

     <!-- Dashboard Js -->
     <script src="assets/js/pages/dashboard.js"></script>
     <script>
          (function() {
               // 🔹 Función que aplica el estilo según el tema actual
               function applyThemeStyle() {
                    let config = window.__TAPLOX_CONFIG__;

                    // Intentar recuperar de sessionStorage si no está en window
                    if (!config) {
                         const stored = sessionStorage.getItem('__TAPLOX_CONFIG__');
                         if (stored) {
                              try {
                                   config = JSON.parse(stored);
                              } catch (e) {
                                   console.error("Error al parsear __TAPLOX_CONFIG__:", e);
                                   return;
                              }
                         }
                    }

                    if (!config) {
                         console.warn("No se encontró la variable de sesión __TAPLOX_CONFIG__");
                         return;
                    }

                    // 🔍 Mostrar información en consola
                    const tema = config.theme === 'dark' ? 'Obscuro' : 'Luminoso';
                    console.log("🔆 Modo del tema:", tema);
                    console.log("🎨 Color del menú:", config.menu?.color || "No especificado");
                    console.log("📏 Tamaño del menú:", config.menu?.size || "No especificado");

                    // 🔹 Aplicar estilo de sombras según el tema
                    const cards = document.querySelectorAll('.cardEsp');
                    if (config.theme === 'dark') {
                         cards.forEach(card => {
                              card.style.boxShadow = "15px 15px 30px #0a0a0a, -15px -15px 30px #2a2a2a";
                         });
                    } else {
                         cards.forEach(card => {
                              card.style.boxShadow = "15px 15px 30px #bebebe, -15px -15px 30px #ffffff";
                         });
                    }
                    // 🔹 Cambiar color de todos los SVG a gris
                    const svgs = document.querySelectorAll('svg');
                    svgs.forEach(svg => {
                         svg.style.fill = "#9e9e9e";
                         svg.style.stroke = "#9e9e9e";
                    });
               }

               // 🔹 Ejecutar la función ANTES de que se renderice completamente la página
               if (document.readyState === 'loading') {
                    document.addEventListener('DOMContentLoaded', applyThemeStyle);
               } else {
                    applyThemeStyle();
               }

               // 🔹 Agregar evento al botón para actualizar dinámicamente
               document.addEventListener('DOMContentLoaded', () => {
                    const button = document.getElementById('light-dark-mode');
                    if (button) {
                         button.addEventListener('click', () => {
                              applyThemeStyle();
                         });
                    }
               });
          })();
     </script>

     <script>
          document.addEventListener('DOMContentLoaded', () => {
               const button = document.getElementById('light-dark-mode');

               if (button) {
                    button.addEventListener('click', () => {
                         // Obtener la configuración desde window o sessionStorage
                         let config = window.__TAPLOX_CONFIG__;

                         if (!config) {
                              const stored = sessionStorage.getItem('__TAPLOX_CONFIG__');
                              if (stored) {
                                   try {
                                        config = JSON.parse(stored);
                                   } catch (e) {
                                        console.error("Error al parsear __TAPLOX_CONFIG__:", e);
                                        return;
                                   }
                              }
                         }

                         if (!config) {
                              console.warn("No se encontró la variable de sesión __TAPLOX_CONFIG__");
                              return;
                         }

                         // Mostrar información en consola
                         const tema = config.theme === 'dark' ? 'Obscuro' : 'Luminoso';
                         console.log("🔆 Modo del tema:", tema);
                         console.log("🎨 Color del menú:", config.menu?.color || "No especificado");
                         console.log("📏 Tamaño del menú:", config.menu?.size || "No especificado");

                         // Seleccionar todas las tarjetas
                         const cards = document.querySelectorAll('.cardEsp');

                         // Aplicar estilos según el modo del tema
                         if (config.theme === 'dark') {
                              cards.forEach(card => {
                                   card.style.boxShadow = "15px 15px 30px #0a0a0a, -15px -15px 30px #2a2a2a";
                              });
                         } else {
                              cards.forEach(card => {
                                   card.style.boxShadow = "15px 15px 30px #bebebe, -15px -15px 30px #ffffff";
                              });
                         }
                    });
               } else {
                    console.warn("No se encontró el botón con id 'light-dark-mode'");
               }
          });
     </script>


</body>

</html>