<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Banca 14</title>
    <link rel="stylesheet" href="assets/css/estiloLogin.css">
</head>

<body>
    <style>
        .neu-icon {
            width: 100px;
            /* Ajusta el tamaño según tus necesidades */
            height: 100px;
            /* Ajusta el tamaño según tus necesidades */
            border-radius: 50%;
            background: #e0e0e0;
            /* Color de fondo base */
            display: flex;
            justify-content: center;
            align-items: center;
            /* Estilo neu-mórfico inicial (elevado) */
            box-shadow: 6px 6px 12px #bebebe,
                -6px -6px 12px #ffffff;
            transition: all 0.2s ease-in-out;
            cursor: pointer;
        }

        .neu-icon:hover {
            /* Estilo neu-mórfico cuando el cursor está encima (presionado) */
            box-shadow: inset 6px 6px 12px #bebebe,
                inset -6px -6px 12px #ffffff;
        }

        .icon-inner {
            width: 70%;
            /* Ajusta el tamaño del contenido interno */
            height: 70%;
            /* Ajusta el tamaño del contenido interno */
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .logo-image {
            max-width: 100%;
            max-height: 100%;
            display: block;
        }
    </style>
    <?php
    session_start();
    $_SESSION[$session_id] = null;
    $_SESSION[$session_usuario] = null;
    $_SESSION["usuario"] = null;
    $_SESSION["admindif_admin_id"] = null;
    $_SESSION["usuario_id"] = null;
    $_SESSION["tipo_usuario"] =  null;
    $_SESSION["id_cliente_14"] = null;
    ?>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="neu-icon" id="myIcon">
                    <div class="icon-inner">
                        <img src="logoBN.png" alt="Logo" class="logo-image">
                    </div>
                </div>
                <h2>Banca14</h2>
                <p>Ingrese sus datos de inicio</p>
            </div>

            <form class="login-form" id="loginForm" novalidate>
                <div class="form-group">
                    <div class="input-group neu-input">
                        <input type="email" id="email" name="email" required autocomplete="email" placeholder=" ">
                        <label for="email">Correo electrónico</label>
                        <div class="input-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" />
                                <polyline points="22,6 12,13 2,6" />
                            </svg>
                        </div>
                    </div>
                    <span class="error-message" id="emailError"></span>
                </div>

                <div class="form-group">
                    <div class="input-group neu-input password-group">
                        <input type="password" id="password" name="password" required autocomplete="current-password" placeholder=" ">
                        <label for="password">Contraseña</label>
                        <div class="input-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
                                <path d="M7 11V7a5 5 0 0110 0v4" />
                            </svg>
                        </div>
                        <button type="button" class="password-toggle neu-toggle" id="passwordToggle" aria-label="Toggle password visibility">
                            <svg class="eye-open" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z" />
                                <circle cx="12" cy="12" r="3" />
                            </svg>
                            <svg class="eye-closed" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24" />
                                <line x1="1" y1="1" x2="23" y2="23" />
                            </svg>
                        </button>
                    </div>
                    <span class="error-message" id="passwordError"></span>
                </div>


                <div class="form-group">
                    <div class="input-group neu-input password-group">
                        <input type="text" id="2fa" name="2fa" required placeholder=" ">
                        <label for="2fa">2FA</label>
                        <div class="input-icon">
                            <svg fill="#5c5c5cff" viewBox="0 0 32 32" id="icon" xmlns="http://www.w3.org/2000/svg" stroke="#e6e6e6">
                                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                <g id="SVGRepo_iconCarrier">
                                    <defs>
                                        <style>
                                            .cls-1 {
                                                fill: none;
                                            }
                                        </style>
                                    </defs>
                                    <polygon points="11 23.18 9 21.179 7.589 22.589 11 26 17 20 15.59 18.59 11 23.18"></polygon>
                                    <path d="M28,30H24V28h4V16H24V8a4.0045,4.0045,0,0,0-4-4V2a6.0067,6.0067,0,0,1,6,6v6h2a2.0021,2.0021,0,0,1,2,2V28A2.0021,2.0021,0,0,1,28,30Z" transform="translate(0 0)"></path>
                                    <path d="M20,14H18V8A6,6,0,0,0,6,8v6H4a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V16A2,2,0,0,0,20,14ZM8,8a4,4,0,0,1,8,0v6H8ZM20,28H4V16H20Z" transform="translate(0 0)"></path>
                                    <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" class="cls-1" width="32" height="32"></rect>
                                </g>
                            </svg>
                        </div>



                    </div>

                </div>



                <button type="submit" class="neu-button login-btn" onclick="iniciarSesion()">
                    <span class="btn-text">Iniciar sesión</span>
                    <div class="btn-loader">
                        <div class="neu-spinner"></div>
                    </div>
                </button>
            </form>
            <div style="    display: flex;
    justify-content: center;">

                <p style=" color: #9499b7;
    font-size: 15px;
    font-weight: 400;" id="espacioMensaje"></p>
            </div>

            <div class="divider">
                <div class="divider-line"></div>
                <span>Sistema 14</span>
                <div class="divider-line"></div>
            </div>




        </div>
    </div>

    <script src="assets/js/login.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function iniciarSesion() {
            //envio de datos atraves de fetch 
            const envioDatosCuenta = new FormData();
            var pass = document.getElementById('password').value;
            var usuario = document.getElementById('email').value;
            var fa = document.getElementById('2fa').value;
            envioDatosCuenta.append("usuario", usuario);
            envioDatosCuenta.append("password", pass);
            envioDatosCuenta.append("2fa", fa);
            envioDatosCuenta.append("accion", "inicio");
            fetch("api/adminLogin.php", {
                    method: "POST",
                    body: envioDatosCuenta,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    if (data.estatus == "exito") {
                        document.getElementById("espacioMensaje").innerHTML = `
                        <div class="alert alert-success alert-white rounded">
                           
                            <div class="icon"><i class="fa fa-check"></i></div>
                            <strong>Exito!</strong> Inicio de sesion correcto.
                        </div>
                        `;

                        Swal.fire ({
                            title: 'Exito!',
                            text: 'Inicio de sesion correcto.',
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        });
                        //esperar 2 segundos y recargar la pagina
                        setTimeout(function() {
                            //ir a la pagina de inicio
                            window.location.href = "index.php";
                        }, 2000);

                    } else {
                        document.getElementById("espacioMensaje").innerHTML = `
                        <div class="alert alert-info alert-white rounded">
                           
                            <div class="icon"><i class="fa fa-info-circle"></i></div>
                            <strong>Info!</strong> ` + data.estatus + `.
                        </div>
                        `;
                        Swal.fire ({
                            title: 'Info!',
                            text: data.estatus,
                            icon: 'info',
                            confirmButtonText: 'Aceptar'
                        });
                        //esperar 2 segundos y limpiar recargar
                        setTimeout(function() {
                            window.location.reload();
                        }, 4000);
                    }
                });
        }
    </script>
</body>

</html>