<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>Banca Sistema 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banca Sistema 14: Dispersion y gestión de pagos." />
    <meta name="author" content="StackBros" />
    <meta name="keywords" content="Banca Sistema 14" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow" />
    <meta name="theme-color" content="#ffffff">

    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Google Font Family link -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- Vendor css -->
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

    <!-- Icons css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

    <!-- Theme Config js -->
    <script src="assets/js/config.js"></script>
</head>

<body>

    <style>
        .tag {
            background: #e8f0fe;
            color: #0d6efd;
            padding: 4px 8px;
            border-radius: 4px;
            display: flex;
            align-items: center;
            font-size: 13px;
        }

        .tag .remove-tag {
            margin-left: 6px;
            cursor: pointer;
            font-weight: bold;
        }
    </style>
    <style>
        .fade-in {
            animation: fadeInAnim 0.8s forwards;
        }

        @keyframes fadeInAnim {
            from {
                opacity: 0;
                transform: translateY(15px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>

    <?php
    session_start();
    if ($_SESSION["clientes_sistema_14_id"] <> "") {
        include_once "api/adminPagos.php";
        include_once "api/adminClientesFav.php";
        include_once "../funciones.php";
        $con = conectar();
        $id_cliente = $_SESSION["clientes_sistema_14_cliente"];

        $adminClientesFav = new AdministradorClientesFav();
        $adminPagos = new AdministradorPagos();
        $clientesFav = $adminClientesFav->dameClientesFavoritos($_SESSION["clientes_sistema_14_id"]);
        $pagosCliente = $adminPagos->damePagosPorClienteEstado($_SESSION["clientes_sistema_14_cliente"]);
        $cliente_nombre = $_SESSION["clientes_sistema_14_nombre"];
        $id_cliente = $_SESSION["clientes_sistema_14_cliente"];
        $saldo = mysql_este("select sum(saldo_acreditable) as suma from pagos where nombre='$id_cliente'", "suma", $con);
        //$saldo = 1000000; //saldo fijo para pruebas
    }
    ?>


    <!-- START Wrapper -->
    <div class="app-wrapper">
        <!-- Topbar Start -->
        <?php include_once 'template/header.php'; ?>
        <!-- Topbar End -->

        <!-- App Menu Start -->
        <?php include_once 'template/barra.php'; ?>
        <!-- App Menu End -->

        <!-- ==================================================== -->
        <!-- Start right Content here -->
        <!-- ==================================================== -->
        <div class="" style="padding: 1rem;">

            <!-- Start Container Fluid -->
            <div class="container-fluid">

                <!-- ========== Page Title Start ========== -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="mb-0">Plantillas</h4>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Plantillas</a></li>
                                <li class="breadcrumb-item active">Retiro por plantilla</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <!-- ========== Page Title End ========== -->

                <div class="row">
                    <div class="col-xl-12 text-center mb-3">
                        <a href="plantilla.xls" class="btn-success d-inline-flex align-items-center btn-press text-white" style="background-color: #008000; border-color: #008000;">
                            <img src="assets/images/xls.png" alt="" width="24">
                            <span> Descargar plantilla nueva</span>
                        </a>
                    </div>


                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Retiros de la plantilla</h4>
                                <p class="sub-header">
                                    Carga tu plantilla, si no tienes una puedes descargarla <a href="plantilla.xls"><span style="color: green;">Aquí.</span></a>
                                </p>

                                <form>

                                    <div class="row">

                                        <!-- CLABE / TARJETA -->
                                        <div class="mb-2 col-md-12">
                                            <label class="form-label">Correos alternativos <code>(Sepáralos por comas)</code></label>

                                            <div class="tag-input form-control" style="display:flex; flex-wrap:wrap; gap:5px; padding:6px;">
                                                <input type="text" class="tag-field" style="border:0; outline:0; flex:1;" placeholder="Escribe y separa con coma">
                                            </div>
                                        </div>

                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>



                    <div id="bloqueResumen" class="col-xl-12" style="opacity:0; display:none;">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Resumen</h4>




                                <div class="row">

                                    <!-- Saldo previo -->
                                    <div class="col-md-3">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <h6 class="text-muted fw-medium">Saldo previo al retiro</h6>
                                                <h4 id="saldoPrevio" class="mb-0">$ 0.00</h4>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Saldo posterior -->
                                    <div class="col-md-3">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <h6 class="text-muted fw-medium">Saldo posterior al retiro</h6>
                                                <h4 id="saldoPosterior" class="mb-0">$ 0.00</h4>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Total retiro -->
                                    <div class="col-md-3">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <h6 class="text-muted fw-medium">Total retiro</h6>
                                                <h4 id="totalRetiro" class="mb-0">$ 0.00</h4>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Total de retiros cargados -->
                                    <div class="col-md-3">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <h6 class="text-muted fw-medium">Total de retiros cargados</h6>
                                                <h4 id="totalRetirosCargados" class="mb-0">0</h4>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>

                        </div>
                    </div>

                    <div class="text-center mb-3">

                        <input type="file" id="inputExcel" accept=".xls" class="d-none">

                        <button id="btnAddForm" type="button" class="btn-success d-inline-flex align-items-center btn-press text-white" style="background-color: #289e28ff; border-color: #B5FFB5;">
                            <span id="textCarga">Cargar plantilla</span>

                            <span id="spinnerCarga" class="spinner-border spinner-border-sm ms-2 d-none"></span>
                        </button>




                    </div>

                    <div class="d-flex justify-content-center align-items-center" style="text-align: center;" id="card2fa">
                        <div class="col-xl-2 col-md-4 col-sm-8">
                            <div class="card shadow">
                                <div class="card-body">
                                    <h4 class="header-title mb-3">Ingresa el 2FA</h4>
                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <input type="text" class="form-control text-center" id="inputCity" placeholder="Código 2FA">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div style="align-items: center; text-align: center; margin-top: 20px; padding-bottom: 20px;">
                        <button id="btnEnviar" class="btn btn-primary d-inline-flex align-items-center btn-press" type="button">
                            <span class="btn-text">Enviar</span>
                            <!-- Spinner (oculto inicialmente) -->
                            <span class="spinner-border spinner-border-sm ml-2 d-none" role="status" aria-hidden="true"></span>
                            <!-- Check (oculto inicialmente) -->
                            <span class="ml-2 d-none" id="iconCheck" aria-hidden="true">
                                <!-- SVG de check -->
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor">
                                    <path fill-rule="evenodd" d="M13.485 1.929a.75.75 0 0 1 .086 1.057l-7 8a.75.75 0 0 1-1.09.04l-3-3a.75.75 0 1 1 1.06-1.06l2.42 2.42 6.47-7.39a.75.75 0 0 1 1.054-.067z" />
                                </svg>
                            </span>
                        </button>
                    </div>

                    <div class="col-xl-12" id="bloqueRetiros" style="opacity:0; display:none;">
                        <div class="card">
                            <div class="card-body">

                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h4 class="header-title">Retiros cargados</h4>
                                        <p class="sub-header">Verifica que los retiros cargados sean correctos.</p>
                                    </div>

                                    <!-- BOTÓN DESCARGAR -->
                                    <button id="btnDescargarErrores"
                                        class="btn btn-warning btn-sm btn-press text-white"
                                        style="white-space: nowrap;" onclick="descargarErroresXLS()">
                                        Descargar informe de errores
                                    </button>
                                </div>

                                <div class="row mt-3">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-centered">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Beneficiario</th>
                                                    <th>Tarjeta/Cuenta</th>
                                                    <th>Monto</th>
                                                    <th>Teléfono</th>
                                                    <th>Banco</th>
                                                    <th>Estado</th>
                                                </tr>
                                            </thead>
                                            <tbody id="cuerpoTabla"></tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>




                </div>






            </div>
            <!-- End Container Fluid -->

            <!-- Footer Start -->
            <?php include_once 'template/footer.php'; ?>
            <!-- Footer End -->

        </div>
        <!-- ==================================================== -->
        <!-- End Page Content -->
        <!-- ==================================================== -->

    </div>
    <!-- END Wrapper -->

    <!-- Vendor Javascript -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App Javascript -->
    <script src="assets/js/app.js"></script>

    <!-- Vector Map Js -->
    <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world.js"></script>

    <!-- Dashboard Js -->
    <script src="assets/js/pages/dashboard.js"></script>
    <script>
        // Convierte texto separado por comas en etiquetas dinámicas
        function iniciarTagInput(container) {

            const input = container.querySelector(".tag-field");
            const tagsContainer = container.querySelector(".tag-list"); // <div> donde están los tags

            input.addEventListener("keyup", function(e) {

                // Crear tag con coma
                if (e.key === ",") {
                    let valor = input.value.replace(",", "").trim();
                    if (valor.length > 0) {
                        agregarTag(container, valor);
                    }
                    input.value = "";
                }

                // Eliminar última tag con backspace
                if (e.key === "Backspace" && input.value.trim() === "") {
                    eliminarUltimoTag(container);
                }
            });
        }

        function agregarTag(container, texto) {
            // Crear etiqueta
            const tag = document.createElement("span");
            tag.classList.add("tag");
            tag.innerHTML = `${texto}<span class="remove-tag">×</span>`;

            // Insertar la etiqueta ANTES del input
            const input = container.querySelector(".tag-field");
            container.insertBefore(tag, input);

            // Habilitar botón de borrar
            tag.querySelector(".remove-tag").addEventListener("click", function() {
                tag.remove();
            });
        }

        function eliminarUltimoTag(container) {
            const tags = container.querySelectorAll(".tag-item"); // clase de cada tag

            if (tags.length > 0) {
                tags[tags.length - 1].remove();
            }
        }

        // Inicializar en todos los formularios actuales y futuros
        document.querySelectorAll(".tag-input").forEach(t => iniciarTagInput(t));
    </script>
    <script>
        window.erroresExcel = []; // ← variable global para almacenar errores

        document.getElementById("btnAddForm").addEventListener("click", () => {
            document.getElementById("inputExcel").click();
        });

        document.getElementById("inputExcel").addEventListener("change", async function() {

            if (this.files.length === 0) return;

            const archivo = this.files[0];
            const cuerpoTabla = document.getElementById("cuerpoTabla");

            // Loader
            document.getElementById("textCarga").textContent = "Cargando...";
            document.getElementById("spinnerCarga").classList.remove("d-none");
            document.getElementById("btnAddForm").disabled = true;

            const fd = new FormData();
            fd.append("file", archivo);
            fd.append("saldo", <?= $saldo ?>);

            try {
                const resp = await fetch("api/dameBancosXls_n.php", {
                    method: "POST",
                    body: fd
                });

                const json = await resp.json();

                cuerpoTabla.innerHTML = "";
                window.erroresExcel = []; // limpiar errores previos

                json.forEach((item, idx) => {
                    if (!item.nombre) return; // saltar filas sin nombre
                    const tr = document.createElement("tr");

                    tr.innerHTML = `
                <td>${idx + 1}</td>
                <td>${item.nombre}</td>
                <td>${item.targeta}</td>
                <td>$ ${parseFloat(item.monto).toLocaleString("es-MX", {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })}</td>
                <td>${item.telefono || ""}</td>
                <td>${item.banco?.bank?.name || ""}</td>
                <td style='display:none;'>${item.cat_id_banco || ""}</td>
                <td class="estado-envio">${item.error || ""}</td>
            `;

                    cuerpoTabla.appendChild(tr);

                    // Guardar solo errores
                    if ((item.error || "").toLowerCase() !== "correcto") {
                        window.erroresExcel.push(item);
                    }
                });

                actualizarResumen();
                mostrarBloquesRetiros();

            } catch (error) {
                console.error(error);
                alert("Error al procesar la plantilla.");
            }

            //nombre del archivo subido
            var nombreArchivo = archivo.name;
            console.log("Archivo subido: " + nombreArchivo);
            document.getElementById("textCarga").textContent = "Plantilla cargada (" + nombreArchivo + ")";
            //desactivar el boton de carga
            document.getElementById("btnAddForm").disabled = true;
            document.getElementById("spinnerCarga").classList.add("d-none");
            document.getElementById("btnAddForm").disabled = false;
        });



        // ======================================================
        // DESCARGAR XLS SOLO CUANDO SE PRESIONA EL BOTÓN
        // ======================================================
        function descargarErroresXLS() {

            const errores = window.erroresExcel;

            if (!errores.length) {
                alert("No hay errores para descargar.");
                return;
            }

            let tabla = `
        <table border="1">
            <tr>
                <th>#</th>
                <th>Beneficiario</th>
                <th>Tarjeta</th>
                <th>Monto</th>
                <th>Banco</th>
                <th>Error</th>
                <th>Teléfono</th>
            </tr>
    `;

            errores.forEach((e, i) => {
                tabla += `
            <tr>
                <td>${i + 1}</td>
                <td>${e.nombre}</td>
                <td>${e.targeta}</td>
                <td>${e.monto}</td>
                <td>${e.banco?.bank?.name || ""}</td>
                <td>${e.error}</td>
                <td>${e.telefono || ""}</td>
            </tr>
        `;
            });

            tabla += `</table>`;

            const blob = new Blob([tabla], {
                type: "application/vnd.ms-excel"
            });
            const url = URL.createObjectURL(blob);

            const a = document.createElement("a");
            a.href = url;
            a.download = "errores_retiros.xls";
            a.click();

            URL.revokeObjectURL(url);
        }
    </script>


    <script>
        document.getElementById("btnEnviar").addEventListener("click", async function() {

            const btn = this;
            const spinner = btn.querySelector(".spinner-border");
            const checkBtn = btn.querySelector("#iconCheck");

            // Mostrar loader
            spinner.classList.remove("d-none");
            checkBtn.classList.add("d-none");
            btn.disabled = true;

            // Tomar el 2FA
            const codigo2FA = document.getElementById("inputCity").value.trim();
            if (!codigo2FA) {
                alert("Debes ingresar el código 2FA.");
                spinner.classList.add("d-none");
                btn.disabled = false;
                return;
            }

            //remover el 2fa 
            document.getElementById("card2fa").style.display = "none";

            // Todas las filas cargadas
            const filas = document.querySelectorAll("#cuerpoTabla tr");

            try {

                // Enviar movimientos uno por uno
                // Enviar movimientos uno por uno
                for (let i = 0; i < filas.length; i++) {

                    const fila = filas[i];

                    const nombre = fila.cells[1].textContent.trim();
                    const tarjeta = fila.cells[2].textContent.trim();
                    const monto = fila.cells[3].textContent.replace("$", "").trim();
                    const telefono = fila.cells[4].textContent.trim();
                    const idBanco = fila.cells[6].textContent.trim();

                    let fd = new FormData();
                    fd.append("nombre", nombre);
                    fd.append("numero", tarjeta);
                    fd.append("monto", monto);
                    fd.append("telefono", telefono);
                    fd.append("concepto", "Deposito");
                    fd.append("correo", "");
                    fd.append("2fa", codigo2FA);
                    fd.append("idBanco", idBanco);

                    const resp = await fetch("envia_retiro_fun.php", {
                        method: "POST",
                        body: fd
                    });

                    const resultText = await resp.text();
                    console.log("Movimiento enviado:", resultText);

                    let data;
                    try {
                        data = JSON.parse(resultText);
                    } catch (e) {
                        data = {
                            status: "error",
                            mensaje: "Respuesta inválida del servidor"
                        };
                    }

                    // Seleccionar celda de estado
                    let celda = fila.querySelector(".estado-envio");

                    // Mostrar ícono según respuesta
                    if (data.status === "ok") {

                        celda.innerHTML = `
                        <span style="color:green; font-size:20px;" title="${data.mensaje}">
                            ✔
                        </span>
                    `;

                    } else {

                        celda.innerHTML = `
                    <span style="color:#E0A800; font-size:20px; cursor:pointer;" title="${data.mensaje}">
                        ⚠
                    </span>
                `;

                        window.postMessage({
                            tipo: "error_pago_masivo",
                            datos: {
                                nombre,
                                tarjeta,
                                monto,
                                telefono,
                                error: data.mensaje,
                                id_sesion: "adasdasdasdasds"
                            }
                        }, "*");

                    }
                }


                // Todos completados
                spinner.classList.add("d-none");
                checkBtn.classList.remove("d-none");

                // Cambiar a botón verde
                btn.style.background = "green";
                btn.style.borderColor = "green";

                // Cambiar texto del botón
                btn.querySelector(".btn-text").textContent = "Ver movimientos";

                // Reactivar botón pero ahora con acción de redirección
                btn.disabled = false;
                btn.onclick = function() {
                    window.location.href = "movimientos.php";
                };

                // Desactivar TODOS los demás botones del sistema
                desactivarTodosLosBotones(btn);

            } catch (error) {
                spinner.classList.add("d-none");
                btn.disabled = false;
                alert("Error al enviar los movimientos.");
            }
        });


        // ========================================================
        // FUNCIÓN → DESACTIVAR TODOS LOS BOTONES EXCEPTO "Ver movimientos"
        // ========================================================
        function desactivarTodosLosBotones(exceptoEste) {
            document.querySelectorAll("button").forEach(btn => {
                if (btn !== exceptoEste) {
                    btn.disabled = true;
                    btn.style.opacity = "0.6";
                    btn.style.cursor = "not-allowed";
                }
            });
        }
    </script>
    <script>
        function actualizarResumen() {

            let totalRetiro = 0;
            const filas = document.querySelectorAll("#cuerpoTabla tr");

            filas.forEach(fila => {
                const montoTexto = fila.cells[3].textContent.replace("$", "").trim();
                //quitar comas 
                const montoTextoSinComas = montoTexto.replace(/,/g, "");
                const monto = parseFloat(montoTextoSinComas);
                if (!isNaN(monto)) totalRetiro += monto;
            });

            // Muestra totales en pantalla
            document.getElementById("totalRetiro").textContent =
                "$ " + totalRetiro.toLocaleString("es-MX", {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });

            document.getElementById("totalRetirosCargados").textContent = filas.length;

            // Si tu backend te da saldo previo, actualízalo aquí
            let saldoPrevio = <?= $saldo ?> || 0;

            document.getElementById("saldoPrevio").textContent =
                "$ " + saldoPrevio.toLocaleString("es-MX", {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });

            let saldoPosterior = saldoPrevio - totalRetiro;

            if (saldoPosterior < 0) {
                //desactivar oton enviar 
                var botonEnviar = document.getElementById("btnEnviar");
                botonEnviar.disabled = true;
                botonEnviar.style.background = "gray";
                botonEnviar.style.borderColor = "gray";
                botonEnviar.innerHTML = "Saldo insuficiente";
                var colorAlerta = 'red';
                document.getElementById("saldoPosterior").style.color = colorAlerta;
            }

            document.getElementById("saldoPosterior").textContent =
                "$ " + saldoPosterior.toLocaleString("es-MX", {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
        }
    </script>

    <script>
        function mostrarBloquesRetiros() {
            const retiros = document.getElementById("bloqueRetiros");
            const resumen = document.getElementById("bloqueResumen");

            // Mostrar y aplicar fade-in
            retiros.style.display = "block";
            resumen.style.display = "block";

            setTimeout(() => {
                retiros.classList.add("fade-in");
                resumen.classList.add("fade-in");
            }, 50); // pequeño delay para que el fade se active correctamente
        }
    </script>


</body>

</html>