<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>Banca Sistema 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banca Sistema 14: Dispersion y gestión de pagos." />
    <meta name="author" content="StackBros" />
    <meta name="keywords" content="Banca Sistema 14" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow" />
    <meta name="theme-color" content="#ffffff">

    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Google Font Family link -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- Vendor css -->
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

    <!-- Icons css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

    <!-- Theme Config js -->
    <script src="assets/js/config.js"></script>
</head>

<body>

    <!-- START Wrapper -->
    <div class="app-wrapper" style="">
        <!-- Topbar Start -->
        <?php include_once 'template/header.php'; ?>
        <!-- Topbar End -->

        <!-- App Menu Start -->
        <?php include_once 'template/barra.php'; ?>

        <?php
        session_start();
        include_once "api/adminClientesFav.php";
        include_once "../funciones.php";
        $con = conectar();
        $id_cliente = $_SESSION["clientes_sistema_14_cliente"];
        $adminClientesFav = new AdministradorClientesFav();
        $clientes = $adminClientesFav->dameClientesFavoritos($_SESSION["clientes_sistema_14_id"]);
        $saldo = mysql_este("select sum(saldo_acreditable) as suma from pagos where nombre='$id_cliente'", "suma", $con);
        $verifica_2fa = mysql_este("select 2fa from usuarios where id='$id_cliente'", "2fa", $con);


        //echo var_dump($clientesFav);


        ?>

        <?php
        $clientesJS = [];
        foreach ($clientes as $cli) {
            $clientesJS[] = [
                "nombre" => $cli->nombre,
                "numero" => $cli->numero,
                "correo" => $cli->correo,
                "telefono" => $cli->telefono,
            ];
        }
        ?>

        <script>
            const CLIENTES = <?php echo json_encode($clientesJS); ?>;
        </script>
        <!-- App Menu End -->

        <!-- ==================================================== -->
        <!-- Start right Content here -->
        <!-- ==================================================== -->
        <div class="" style="padding: 1rem;">

            <!-- Start Container Fluid -->
            <div class="container-fluid">

                <!-- ========== Page Title Start ========== -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">

                            <h4 class="mb-0" id="espacio_total">
                                Saldo posterior: $<?php echo number_format($saldo, 2); ?>
                                Total: $0.00
                            </h4>



                            <!-- BOTÓN CENTRADO -->
                            <div class="text-center mt-3">
                                <a href="traspasos.php" class="btn btn-primary px-4 py-2" id="btnTraspaso">
                                    Traspaso entre cuentas
                                </a>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- ========== Page Title End ========== -->

                <div class="row">

                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Retiro 1</h4>
                                <p class="sub-header">
                                    Ingresa los datos del beneficiario.
                                </p>

                                <form>

                                    <div class="row">

                                        <!-- BENEFICIARIO -->
                                        <div class="mb-2 col-md-5 beneficiario-group">
                                            <span class="save-contact-icon d-none" style="
                                                position:absolute;
                                                top:-5px;
                                                right:-5px;
                                                cursor:pointer;
                                                font-size:20px;
                                                color:#0d6efd;
                                            " title="Guardar contacto">
                                                💾
                                            </span>
                                            <label class="form-label">Beneficiario <code>*</code></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control beneficiario-input" placeholder="Escribe o selecciona">

                                                <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"></button>

                                                <ul class="dropdown-menu dropdown-menu-end beneficiario-dropdown">
                                                    <!-- Se llena con JS -->
                                                </ul>
                                            </div>
                                        </div>

                                        <!-- CLABE / TARJETA -->
                                        <div class="mb-2 col-md-4">
                                            <label class="form-label label-clabe-tarjeta">CLABE / Tarjeta <code>*</code></label>
                                            <input type="text" class="form-control input-numero">
                                        </div>

                                        <!-- MONTO -->
                                        <div class="mb-2 col-md-3">
                                            <label class="form-label">Monto <code>*</code></label>
                                            <input type="text" class="form-control input-monto">
                                        </div>

                                        <!-- CONCEPTO -->
                                        <div class="mb-2 col-md-6">
                                            <label class="form-label">Concepto <code></code></label>
                                            <input type="text" class="form-control input-concepto" placeholder="Deposito">
                                        </div>

                                        <!-- CORREO -->
                                        <div class="mb-2 col-md-3">
                                            <label class="form-label">Correo</label>
                                            <input type="text" class="form-control input-correo">
                                        </div>

                                        <!-- TELEFONO -->
                                        <div class="mb-2 col-md-3">
                                            <label class="form-label">Teléfono</label>
                                            <input type="text" class="form-control input-telefono">
                                        </div>

                                        <input type="" class="input-idBanco" value="0" style="display:none;">


                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                    <div id="extraForms"></div>

                    <div class="text-center mb-3">
                        <button id="btnAddForm" type="button" class="btn btn-success">
                            <strong style="font-size: 20px;">+</strong>
                        </button>
                    </div>

                    <div class="d-flex justify-content-center align-items-center" style="text-align: center;">
                        <div class="col-xl-2 col-md-4 col-sm-8">
                            <div class="card shadow">
                                <div class="card-body">
                                    <h4 class="header-title mb-3">Ingresa el 2FA</h4>
                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <input type="text" class="form-control text-center" id="inputCity" placeholder="Código 2FA">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div style="align-items: center; text-align: center; margin-top: 20px;">
                        <button id="btnEnviar" class="btn btn-primary d-inline-flex align-items-center" type="button">
                            <span class="btn-text">Enviar</span>
                            <!-- Spinner (oculto inicialmente) -->
                            <span class="spinner-border spinner-border-sm ml-2 d-none" role="status" aria-hidden="true"></span>
                            <!-- Check (oculto inicialmente) -->
                            <span class="ml-2 d-none" id="iconCheck" aria-hidden="true">
                                <!-- SVG de check -->
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor">
                                    <path fill-rule="evenodd" d="M13.485 1.929a.75.75 0 0 1 .086 1.057l-7 8a.75.75 0 0 1-1.09.04l-3-3a.75.75 0 1 1 1.06-1.06l2.42 2.42 6.47-7.39a.75.75 0 0 1 1.054-.067z" />
                                </svg>
                            </span>
                        </button>
                    </div>

                </div>






            </div>
            <!-- End Container Fluid -->

            <!-- Footer Start -->
            <?php include_once 'template/footer.php'; ?>
            <!-- Footer End -->

        </div>
        <!-- ==================================================== -->
        <!-- End Page Content -->
        <!-- ==================================================== -->

    </div>
    <!-- END Wrapper -->

    <!-- Vendor Javascript -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App Javascript -->
    <script src="assets/js/app.js"></script>

    <!-- Vector Map Js -->
    <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world.js"></script>

    <!-- Dashboard Js -->
    <script src="assets/js/pages/dashboard.js"></script>
    <script>
        /* ======================================================
   MOSTRAR/OCULTAR ÍCONO DE GUARDAR CUANDO NO ES CLIENTE
========================================================= */
        function configurarIconoGuardar(group) {
            const input = group.querySelector(".beneficiario-input");
            const icon = group.querySelector(".save-contact-icon");

            input.addEventListener("input", () => {
                const nombre = input.value.trim();

                // Revisar si coincide con algún cliente
                const existe = CLIENTES.some(cli => cli.nombre.toLowerCase() === nombre.toLowerCase());

                if (nombre.length > 0 && !existe) {
                    icon.classList.remove("d-none"); // mostrar icono
                } else {
                    icon.classList.add("d-none"); // ocultar icono
                }
            });
        }

        /* ======================================================
           LLENAR DROPDOWN Y AUTOCOMPLETAR FORM (ya existía)
        ========================================================= */
        function cargarClientesEnDropdown(group) {

            let ul = group.querySelector(".beneficiario-dropdown");
            ul.innerHTML = "";

            CLIENTES.forEach(cli => {
                let li = document.createElement("li");
                li.innerHTML = `<a class="dropdown-item" href="#">${cli.nombre}</a>`;

                li.addEventListener("click", () => {

                    group.querySelector(".beneficiario-input").value = cli.nombre;
                    group.querySelector(".save-contact-icon").classList.add("d-none"); // ocultar icono

                    let form = group.closest("form");
                    form.querySelector(".input-numero").value = cli.numero;
                    form.querySelector(".input-correo").value = cli.correo;
                    form.querySelector(".input-telefono").value = cli.telefono;
                    // actualizar id banco 
                    initDetectorCuentaTarjeta(form);
                });

                ul.appendChild(li);
            });

            // Activar icono guardar
            configurarIconoGuardar(group);
        }

        /* Inicializa en formulario principal */
        document.querySelectorAll(".beneficiario-group")
            .forEach(g => cargarClientesEnDropdown(g));



        /* ======================================================
           GUARDAR CONTACTO POR FETCH
        ========================================================= */
        document.addEventListener("click", async function(e) {

            if (e.target.classList.contains("save-contact-icon")) {

                let group = e.target.closest(".beneficiario-group");
                let form = group.closest("form");

                // Recoger valores
                let data = {
                    nombre: form.querySelector(".beneficiario-input").value,
                    numero: form.querySelector(".input-numero").value,
                    correo: form.querySelector(".input-correo").value,
                    telefono: form.querySelector(".input-telefono").value
                };

                // Petición
                let response = await fetch("api/apiContactosBanca.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify(data)
                });

                let result = await response.json();

                if (result.estatus === "ok") {
                    alert("Contacto guardado correctamente");
                    e.target.classList.add("d-none"); // Ocultar icono
                } else {
                    alert("Error al guardar: " + result.mensaje);
                }
            }
        });


        /* ======================================================
           CLONADO DEL FORMULARIO (ya lo tienes)
        ========================================================= */
        let formCount = 0;
        const maxForms = 5;

        document.getElementById("btnAddForm").addEventListener("click", function() {
            if (formCount >= maxForms) {
                document.getElementById("limitMsg").classList.remove("d-none");
                return;
            }

            const originalForm = document.querySelector(".card-body form");
            const cloneForm = originalForm.cloneNode(true);
            cloneForm.querySelectorAll("input").forEach(i => i.value = "");

            const card = document.createElement("div");
            card.classList.add("card", "mt-3", "shadow");

            const cardBody = document.createElement("div");
            cardBody.classList.add("card-body");

            const title = document.createElement("h4");
            title.classList.add("header-title", "mb-3");
            title.textContent = `Retiro ${formCount + 2}`;

            cardBody.appendChild(title);
            cardBody.appendChild(cloneForm);
            card.appendChild(cardBody);

            document.getElementById("extraForms").appendChild(card);

            // Activar dropdown + icono para nuevo formulario
            cargarClientesEnDropdown(cardBody.querySelector(".beneficiario-group"));
            initMontoEvents(cardBody);
            initDetectorCuentaTarjeta(cardBody);


            formCount++;

            if (formCount >= maxForms) {
                document.getElementById("limitMsg").classList.remove("d-none");
            }
        });
    </script>




    <script>
        (function() {
            const btn = document.getElementById('btnEnviar');
            const text = btn.querySelector('.btn-text');
            const spinner = btn.querySelector('.spinner-border');
            const check = document.getElementById('iconCheck');
            btn.addEventListener('click', function() {
                // Evitar doble clic
                if (btn.disabled) return;

                // Estado: Enviando...
                btn.disabled = true;
                spinner.classList.remove('d-none');
                check.classList.add('d-none');
                text.textContent = 'Enviando...';

                // Después de 5 segundos, mostrar "Enviado" y cambiar a verde
                setTimeout(() => {
                    spinner.classList.add('d-none');
                    check.classList.remove('d-none');
                    text.textContent = 'Enviado';

                    // Cambiar de azul a verde
                    btn.classList.remove('btn-primary');
                    btn.classList.add('btn-success');

                    // (Opcional) Si quieres permitir volver a enviar, reactivar:
                    // btn.disabled = false; text.textContent = 'Enviar'; check.classList.add('d-none');
                    // btn.classList.remove('btn-success'); btn.classList.add('btn-primary');
                }, 5000);
            });
        })();
    </script>
    <script>
        // ============================================================
        //  FUNCIÓN PARA EXTRAER LOS DATOS DE UN FORMULARIO
        // ============================================================
        function obtenerDatosFormulario(form, codigo2FA) {
            const fd = new FormData();

            fd.append("nombre", form.querySelector(".beneficiario-input").value.trim());
            fd.append("numero", form.querySelector(".input-numero").value.trim());
            fd.append("monto", form.querySelector(".input-monto").value.trim());
            fd.append("concepto", form.querySelector(".input-concepto").value.trim());
            fd.append("correos", form.querySelector(".input-correo").value.trim());
            fd.append("telefono", form.querySelector(".input-telefono").value.trim());
            fd.append("idBanco", form.querySelector(".input-idBanco").value.trim());
            // AÑADIR 2FA A CADA ENVÍO
            fd.append("2fa", codigo2FA.trim());

            return fd;
        }


        // ============================================================
        //  FUNCIÓN PARA ENVIAR UN MOVIMIENTO VIA FETCH CON FORMDATA
        // ============================================================
        async function enviarMovimientoFormData(formData) {
            const response = await fetch("envia_retiro_fun.php", {
                method: "POST",
                body: formData
            });

            return await response.text();
        }


        // ============================================================
        //  BOTÓN ENVIAR - ENVÍO SECUENCIAL
        // ============================================================
        document.getElementById("btnEnviar").addEventListener("click", async function() {

            const btn = this;
            const spinner = btn.querySelector(".spinner-border");
            const check = btn.querySelector("#iconCheck");
            const codigo2FA = document.querySelector("#inputCity").value.trim();

            // Validar 2FA
            if (!codigo2FA) {
                alert("Debes ingresar el código 2FA.");
                return;
            }

            // UI
            check.classList.add("d-none");
            spinner.classList.remove("d-none");

            // Tomar TODOS los formularios
            const formularios = document.querySelectorAll("#extraForms form, .card-body form");

            try {
                // Enviar uno por uno
                for (let form of formularios) {

                    const fd = obtenerDatosFormulario(form, codigo2FA);

                    // Validación mínima antes de enviar
                    if (!fd.get("nombre") || !fd.get("numero") || !fd.get("monto")) {
                        spinner.classList.add("d-none");
                        alert("Hay un formulario con datos incompletos.");
                        return;
                    }

                    const respuesta = await enviarMovimientoFormData(fd);
                    var respuestaJSON = JSON.parse(respuesta);
                    var listaErrores = [];
                    if (respuestaJSON.status !== "ok") {
                        spinner.classList.add("d-none");
                        listaErrores.push(respuestaJSON.mensaje);
                    }
                    console.log("Movimiento enviado:", respuesta);
                }

                // Si todo terminó bien
                spinner.classList.add("d-none");
                check.classList.remove("d-none");

                if (listaErrores.length > 0) {
                    alert("Algunos movimientos tuvieron errores:\n" + listaErrores.join("\n"));
                } else {
                    alert("Todos los movimientos se enviaron correctamente.");
                }

            } catch (error) {
                spinner.classList.add("d-none");
                alert("Error al enviar un movimiento:\n" + error);
            }
        });
    </script>

    <script>
        /* ======================================================
   FORMATEAR MONTOS Y SUMAR TOTAL
========================================================= */
        function initMontoEvents(context = document) {
            const montoInputs = context.querySelectorAll(".input-monto");

            montoInputs.forEach(input => {
                input.addEventListener("input", function() {
                    let value = this.value;

                    // Quitar comas y caracteres no permitidos
                    value = value.replace(/,/g, "").replace(/[^0-9.]/g, "");

                    // Evitar más de un punto decimal
                    let parts = value.split(".");
                    if (parts.length > 2) {
                        value = parts[0] + "." + parts[1];
                        parts = value.split(".");
                    }

                    // Limitar decimales a máximo 2
                    if (parts[1] && parts[1].length > 2) {
                        parts[1] = parts[1].substring(0, 2);
                        value = parts.join(".");
                    }

                    // Formatear si es número
                    if (value !== "" && !isNaN(value)) {
                        const num = Number(value);

                        // Solo formatear si no se está escribiendo justo después del punto
                        if (!(value.endsWith(".") || value.endsWith("."))) {
                            this.value = num.toLocaleString("en-US", {
                                minimumFractionDigits: parts[1] ? parts[1].length : 0,
                                maximumFractionDigits: 2
                            });
                        } else {
                            this.value = value;
                        }
                    } else {
                        this.value = "";
                    }

                    calcularTotalMontos();
                });
            });
        }

        /* ======================================================
           SUMAR TODOS LOS MONTOS
        ========================================================= */
        function calcularTotalMontos() {
            let total = 0;
            let saldo = <?= $saldo; ?>;
            let restante = saldo;
            const inputs = document.querySelectorAll(".input-monto");

            inputs.forEach(input => {
                const raw = input.value.replace(/,/g, "");
                const val = parseFloat(raw);
                if (!isNaN(val)) total += val;
            });

            restante -= total;
            restante = restante.toLocaleString("es-MX", {
                style: "currency",
                currency: "MXN",
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });

            console.log("TOTAL MONTOS:", total.toLocaleString("es-MX", {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            }));

            document.getElementById("espacio_total").textContent = "Saldo posterior: " + restante + "  Total: " + total.toLocaleString("es-MX", {
                style: "currency",
                currency: "MXN",
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });

            if (total > saldo) {
                document.getElementById("espacio_total").style.color = "red";
                //desactivar boton enviar
                document.getElementById("btnEnviar").disabled = true;
            } else {
                document.getElementById("espacio_total").style.color = "black";
                document.getElementById("btnEnviar").disabled = false;
            }

            return total;
        }

        // Inicializar para el formulario principal
        document.addEventListener("DOMContentLoaded", function() {
            initMontoEvents();
            initDetectorCuentaTarjeta();
        });
    </script>

    <script>
        function initDetectorCuentaTarjeta(context = document) {

            const numeroInputs = context.querySelectorAll(".input-numero");

            numeroInputs.forEach(input => {

                input.addEventListener("input", async function() {

                    let numero = this.value.replace(/\D/g, ""); // Limpiar no dígitos
                    this.value = numero; // Mantener solo números

                    const form = this.closest("form");
                    const label = form.querySelector("label[for='clabeTarjetaLabel']") ||
                        form.querySelector(".label-clabe-tarjeta") ||
                        form.querySelector(".form-label"); // etiqueta actual

                    const hiddenBanco = form.querySelector(".input-idBanco");

                    // VALIDACIONES
                    if (numero.length < 16) {
                        label.innerHTML = `CLABE / Tarjeta <code style="color:red;">Número no válido</code>`;
                        hiddenBanco.value = "";
                        return;
                    }

                    if (numero.length === 17) {
                        label.innerHTML = `CLABE / Tarjeta <code style="color:red;">Número no válido</code>`;
                        hiddenBanco.value = "";
                        return;
                    }

                    // ⭐ CLABE (18 dígitos)
                    if (numero.length === 18) {
                        label.innerHTML = `CLABE`;
                        hiddenBanco.value = ""; // no se usa banco para CLABE
                        return;
                    }

                    // ⭐ TARJETA (16 dígitos)
                    if (numero.length === 16) {

                        const primeros6 = numero.substring(0, 6);

                        label.innerHTML = `Tarjeta <span style="color:orange;">Buscando banco...</span>`;
                        hiddenBanco.value = "";

                        try {
                            const resp = await fetch(`api/dameBancoCatalogoL.php?numero=${primeros6}`);
                            const json = await resp.json();

                            if (json.bank && json.bank.name) {
                                label.innerHTML = `Tarjeta (${json.bank.name})`;
                                hiddenBanco.value = json.bank.code || "";
                            } else {
                                label.innerHTML = `Tarjeta <code style="color:red;">Banco desconocido</code>`;
                            }

                        } catch (e) {
                            label.innerHTML = `Tarjeta <code style="color:red;">Error al consultar</code>`;
                        }

                        return;
                    }

                });
            });
        }
    </script>

</body>

</html>