<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>Banca Sistema 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banca Sistema 14: Dispersion y gestión de pagos." />
    <meta name="author" content="StackBros" />
    <meta name="keywords" content="Banca Sistema 14" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow" />
    <meta name="theme-color" content="#ffffff">

    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Google Font Family link -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- Vendor css -->
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

    <!-- Icons css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

    <!-- Theme Config js -->
    <script src="assets/js/config.js"></script>
</head>

<body>

    <!-- START Wrapper -->
    <div class="app-wrapper">
        <!-- Topbar Start -->
        <?php include_once 'template/header.php'; ?>
        <!-- Topbar End -->

        <!-- App Menu Start -->
        <?php include_once 'template/barra.php'; ?>

        <?php
        session_start();
        include "funciones.php";
        $con = conectar();
        $cliente_nombre = $_SESSION["clientes_sistema_14_nombre"];
        $id_cliente = $_SESSION["clientes_sistema_14_cliente"];
        $saldo = mysql_este("select sum(saldo_acreditable) as suma from pagos where nombre='$id_cliente'", "suma", $con);
        include_once "api/adminClientesFav.php";
        $adminClientesFav = new AdministradorClientesFav();
        include_once("../plus/clientes/api/adminClientes.php");
        $adminClientes = new AdministradorClientes();
        $cliente = $adminClientes->dameCliente($_SESSION["clientes_sistema_14_cliente"]);
        //echo var_dump($cliente);
        $clientes = $adminClientes->dameClientesGrupo($cliente->grupo);
        //echo var_dump($clientes);


        ?>
        <!-- App Menu End -->

        <!-- ==================================================== -->
        <!-- Start right Content here -->
        <!-- ==================================================== -->
        <div class="" style="padding: 1rem;">

            <!-- Start Container Fluid -->
            <div class="container-fluid">

                <!-- ========== Page Title Start ========== -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="mb-0">Saldo disponible ($ <?php echo number_format($saldo, 2); ?>)</h4>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Movimientos</a></li>
                                <li class="breadcrumb-item active">Traspaso</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <!-- ========== Page Title End ========== -->

                <div class="row">


                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">Traspaso</h4>
                                <p class="sub-header">
                                    Ingresa los datos del traspaso.
                                </p>

                                <form id="formularioTras">

                                    <div class="row">
                                        <!-- CLABE / TARJETA -->
                                        <div class="mb-2 col-md-3">
                                            <label class="form-label label-clabe-tarjeta">Cartera <code>*</code></label>
                                            <select name="cliente_destino" id="cliente_destino" class="form-select select-clabe-tarjeta">
                                                <option value="0">Elegir...</option>
                                                <?php
                                                $clienteExtra = '';
                                                if (intval($id_cliente) == 117) {
                                                    $clienteExtra = "<option value='176'>Ricardo (Stephy)</option>";
                                                }
                                                foreach ($clientes as $cliente) {
                                                    if ($cliente->id != $id_cliente) {
                                                        echo "<option value='" . $cliente->id . "'>" . $cliente->nombre . "</option>";
                                                    }
                                                }
                                                echo $clienteExtra;

                                                ?>
                                            </select>
                                        </div>

                                        <!-- MONTO -->
                                        <div class="mb-2 col-md-3">
                                            <label class="form-label">Monto <code>*</code></label>
                                            <input type="text" id="monto" name="monto" oninput="formatearNumeroBarra()" class="form-control input-monto">
                                        </div>

                                        <!-- CONCEPTO -->
                                        <div class="mb-2 col-md-6">
                                            <label class="form-label">Detalles <code></code></label>
                                            <input type="text" id="detalle" name="detalle" class="form-control input-concepto" placeholder="Deposito">
                                        </div>

                                        <div class="mb-2 col-md-12">
                                            <button type="submit" class="btn btn-primary btn-block btn-press">Realizar Traspaso</button>
                                        </div>


                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>


                </div>






            </div>
            <!-- End Container Fluid -->

            <!-- Footer Start -->
            <?php include_once 'template/footer.php'; ?>
            <!-- Footer End -->

        </div>
        <!-- ==================================================== -->
        <!-- End Page Content -->
        <!-- ==================================================== -->

    </div>
    <!-- END Wrapper -->

    <!-- Vendor Javascript -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App Javascript -->
    <script src="assets/js/app.js"></script>

    <!-- Vector Map Js -->
    <script src="assets/vendor/jsvectormap/js/jsvectormap.min.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world-merc.js"></script>
    <script src="assets/vendor/jsvectormap/maps/world.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Dashboard Js -->
    <script src="assets/js/pages/dashboard.js"></script>
    <script>
        const formularioT = document.getElementById("formularioTras");
        formularioT.addEventListener("submit", function(e) {
            e.preventDefault();


            var saldoCliente = "<?php echo $saldo; ?>";
            var monto = document.getElementById("monto").value;
            monto = monto.replace(/,/g, '');
            var cliente = document.getElementById("cliente_destino").value;


            if (cliente == 0) {
                Swal.fire({
                    title: 'Error',
                    text: 'Selecciona una cartera',
                    icon: 'error',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    cancelButtonText: 'Seguir capturando',
                    confirmButtonText: 'Continuar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        //redirigir 
                        window.location.href = "movimientos.php";

                    }
                })
                return false;
            }

            if (monto <= 0) {
                Swal.fire({
                    title: 'Error',
                    text: 'El monto debe ser mayor a 0',
                    icon: 'error',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    cancelButtonText: 'Seguir capturando',
                    confirmButtonText: 'Continuar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        //redirigir 
                        window.location.href = "movimientos.php";

                    }
                })
                return false;
            }


            var montoFlot = parseFloat(monto);
            var salfoFlot = parseFloat(saldoCliente);
            if (montoFlot > salfoFlot) {
                Swal.fire({
                    title: 'Error',
                    text: 'El monto es mayor al saldo disponible',
                    icon: 'error',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    cancelButtonText: 'Seguir capturando',
                    confirmButtonText: 'Continuar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        //redirigir 
                        window.location.href = "movimientos.php";

                    }
                })
                return false;
            }




            const enviaDatosTraspaso = new FormData(formularioT);
            enviaDatosTraspaso.append("accion", "insertaTraspaso");
            enviaDatosTraspaso.append("usuario_registra", "<?php echo $_SESSION['clientes_sistema_14_cliente'] ?>");
            enviaDatosTraspaso.append("cliente_origen", "<?php echo $_SESSION['clientes_sistema_14_cliente'] ?>");
            fetch("api/reboteTraspaso.php", {
                    method: "POST",
                    body: enviaDatosTraspaso,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        title: data[0].estatus,
                        text: data[0].mensaje,
                        icon: data[0].subMensaje,
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        cancelButtonText: 'Seguir capturando',
                        confirmButtonText: 'Continuar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            //redirigir 
                            window.location.href = "movimientos.php";

                        }
                    })

                }).catch(function(error) {
                    //window.location.href = "historial.php";
                })
        });
    </script>

    <script>
        function formatearNumeroBarra() {
            var input = document.getElementById('monto');
            var valor = input.value.replace(/[^\d.]/g, ''); // Eliminar caracteres no numéricos ni puntos
            //elimina signos negativos
            valor = valor.replace(/^[0]+([,.][0]+)?$/, '');
            var partes = valor.split('.');
            if (partes.length > 2) {
                partes = [partes.shift(), partes.join('.')];
            }
            if (partes.length > 0) {
                partes[0] = partes[0].replace(/\B(?=(\d{3})+(?!\d))/g, ','); // Agregar comas
            }

            input.value = partes.join('.');
        }
    </script>
</body>

</html>