<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>Login Banca 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banca 14." />
    <meta name="author" content="StackBros" />
    <meta name="keywords" content="Banca 14, login" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="robots" content="index, follow" />
    <meta name="theme-color" content="#ffffff">

    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Google Font Family link -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- Vendor css -->
    <link href="assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

    <!-- Icons css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/style.min.css" rel="stylesheet" type="text/css" />

    <!-- Theme Config js -->
    <script src="assets/js/config.js"></script>

</head>
<?php
session_start();
$_SESSION[$session_id] = null;
$_SESSION[$session_usuario] = null;
$_SESSION["usuario"] = null;
$_SESSION["admindif_admin_id"] = null;
$_SESSION["usuario_id"] = null;
$_SESSION["tipo_usuario"] =  null;
$_SESSION["id_cliente_14"] = null;
?>

<body class="authentication-bg">
    <div class="account-pages py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-5">
                    <div class="card border-0 shadow-lg">
                        <div class="card-body p-5">
                            <div class="text-center">
                                <div class="mx-auto mb-4 text-center auth-logo">
                                    <a href="index.html" class="logo-dark">
                                        <img src="img/favicon.png" height="60" alt="logo dark">
                                    </a>

                                    <a href="index.html" class="logo-light">
                                        <img src="img/favicon.png" height="60" alt="logo light">
                                    </a>
                                </div>
                                <h4 class="fw-bold text-dark mb-2">Banca 14</h4>
                                <p class="text-muted"></p>
                            </div>
                            <div class="mt-4">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Correo electronico</label>
                                    <input type="email" class="form-control" id="email" placeholder="Ingresa tu correo electronico">
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <label for="password" class="form-label">Contraseña</label>
                                    </div>
                                    <input type="password" class="form-control" id="password" placeholder="Ingresa tu contraseña">
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <label for="password" class="form-label">2FA</label>
                                    </div>
                                    <input type="text" class="form-control" id="2fa" placeholder="Ingresa tu 2fa">
                                </div>

                                <div class="d-grid">
                                    <button class="btn btn-dark btn-lg fw-medium" onclick="iniciarSesion()" type="submit">Iniciar Sesión</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- Vendor Javascript -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App Javascript -->
    <script src="assets/js/app.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function iniciarSesion() {
            //envio de datos atraves de fetch 
            const envioDatosCuenta = new FormData();
            var pass = document.getElementById('password').value;
            var usuario = document.getElementById('email').value;
            var fa = document.getElementById('2fa').value;
            envioDatosCuenta.append("usuario", usuario);
            envioDatosCuenta.append("password", pass);
            envioDatosCuenta.append("2fa", fa);
            envioDatosCuenta.append("accion", "inicio");
            fetch("api/adminLogin.php", {
                    method: "POST",
                    body: envioDatosCuenta,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        position: 'top-end',
                        icon: "susses",
                        title: data.mensaje,
                        showConfirmButton: false,
                        timer: 1500
                    })
                    if (data.estatus == "exito") {
                        //esperar 2 segundos y recargar la pagina
                        setTimeout(function() {
                            //ir a la pagina de inicio
                                window.location.href = "index.php";
                        }, 2000);

                    }
                });
        }
    </script>

</body>

</html>