<?php

include_once('conectorBDS14.php');

class ItemBusqueda{
  public $id;
  public $tipo;
  public $fecha;
  public $descripcion;
  public $monto;
  public $detalle;
  public $fecha_captura;
  public $cliente;
  public $claveCorta;
  public $captura;
  public $pago;
  public $token;
  public $movimiento;
  public $banco;
  public $fecha_cadena;
  public $fecha_captura_cadena;
  public $saldo_acreditable;

  function __construct($id, $tipo, $fecha, $descripcion, $monto, $detalle, $fecha_captura, $cliente, $claveCorta, $captura, $pago, $token, $movimiento, $banco){
    $this->id = $id;
    $this->tipo = $tipo;
    $this->fecha = $fecha;
    $this->descripcion = $descripcion;
    $this->monto = $monto;
    $this->detalle = $detalle;
    $this->fecha_captura = $fecha_captura;
    $this->cliente = $cliente;
    $this->claveCorta = $claveCorta;
    $this->captura = $captura;
    $this->pago = $pago;
    $this->token = $token;
    $this->movimiento = $movimiento;
    $this->banco = $banco;
  }
}


class AdminBuscador extends conectorS14 {

  public function fechaComoCadena($fecha)
  {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);
  
    switch ($mes) {
      case "01":
        $mes = 'Enero';
        break;
      case "02":
        $mes = 'Febrero';
        break;
      case "03":
        $mes = 'Marzo';
        break;
      case  "04":
        $mes = 'Abril';
        break;
      case "05":
        $mes = 'Mayo';
        break;
      case "06":
        $mes = 'Junio';
        break;
      case "07":
        $mes = 'Julio';
        break;
      case "08":
        $mes = 'Agosto';
        break;
      case "09":
        $mes = 'Septiembre';
        break;
      case "10":
        $mes = 'Octubre';
        break;
      case "11":
        $mes = 'Noviembre';
        break;
      case "12":
        $mes = 'Diciembre';
        break;
      default:
        $mes = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
  }


  public function dameBusqueda($parametro){

    $numero = str_replace(",", "", $parametro);
    $numero = str_replace("$", "", $numero);
    $numero = str_replace(" ", "", $numero);
    $numero = floatval($numero);
    if($numero == 0){
      $numero = "null";
      $numeroTolera1 = 'null';
      $numeroTolera2 = 'null';
    }
    else{
      if($numero<0){
        $numero = $numero * -1;
      }
      $numeroTolera1 = $numero + 0.01;
      $numeroTolera2 = $numero - 0.01;
    }
  

    

  
    $hoyMenosTresMeses = date("Y-m-d",strtotime(date("Y-m-d")."- 3 month"));

    $sql = "
    SELECT facturas.id, 'Factura' AS tipo, fecha_timbrado as fecha, 'FACTURA' as descripcion, total_factura as monto, 'FACTURA S14' as detalle, fecha_timbrado as fecha_captura, clientes.nombre as cliente, 'NA' as clave_corta, 'NA' as captura, id_pago as pago, 'FACTURA EMITIDA' as movimiento, token, 'NA' as banco, 'NA' as saldo_acreditable, 'NA' as fecha_asignacion
    FROM facturas
    inner join detalle_factura
    on detalle_factura.id_factura = facturas.id
    inner join claves_cortas
    on claves_cortas.id = facturas.id_clave_corta
    inner join clientes 
    on clientes.id = claves_cortas.id_cliente
    inner join empresas
    on empresas.id = facturas.razon
    WHERE
    ";

    if($numero!= 0){
      $sql = $sql . "total_iva = '$numero' or  facturas.id = $numero or ";
  }

    $sql = $sql . "
    
     detalle_factura.concepto like '%$parametro%' or clientes.nombre like '%$parametro%' or claves_cortas.clave_corta like '%$parametro%' or claves_cortas.razon_social like '%$parametro%' or claves_cortas.rfc like '%$parametro%' or claves_cortas.rfc like '%$parametro%'
    UNION
    SELECT pagos.id, 'Pago' AS tipo, fecha_banco as fecha, descripcion, monto, detalle, fecha_captura, clientes.nombre as cliente, bancos.nombre_corto, id_captura, 'NA' as pago, tipo_movimiento as movimiento, 'NA' as token, pagos.banco, saldo_acreditable, fecha_asignacion
    FROM pagos
    left join clientes on (clientes.id=pagos.nombre)
    left join captura on (captura.id=pagos.id_captura)
    left join bancos on (bancos.id=captura.nombre_corto)
    LEFT JOIN empresas ON (empresas.id=captura.razon)
    WHERE 
    "; 

    if($numero!= 0){
        $sql = $sql . "ABS(monto = '$numero') or  (ABS(saldo_acreditable) < '$numeroTolera1' and ABS(saldo_acreditable) > '$numeroTolera2' ) or pagos.id = $numero or ";
    }

    $sql = $sql . "
     clientes.nombre like '%$parametro%' or detalle like '%$parametro%' or descripcion like '%$parametro%' or tipo_movimiento like '%$parametro%' or fecha_captura like '%$parametro%' or fecha_banco like '%$parametro%' or  fecha_asignacion like '%$parametro%'
    UNION
    SELECT c.id, 'Captura' AS tipo, fecha, 'CAPTURA S14', 'NA', 'CAPTURA S14', fecha as fecha_captura, '0' , 'NA' as cliente, 'NA' as id_captura, 'NA' as pago, 'Captura de saldos' as movimiento , 'NA' as token, b.nombre_corto as banco, 'NA' as saldo_acreditable , fecha as fecha_asignacion
    FROM captura c
    INNER JOIN pagos p ON c.id = p.id_captura
    INNER JOIN bancos b ON (b.id=c.`nombre_corto`) 
    WHERE 
    ";

    if($numero!= 0){
      $sql = $sql . "p.monto = '$numero' or c.id = $numero or";
  }

    $sql = $sql . "
    c.id = '$parametro'
    ";
    //echo $sql;

    $result = $this->ejecutar($sql);

    $array = array();

    while ($row = $result->fetch_assoc()) {
      $item = new ItemBusqueda($row['id'], $row['tipo'], ($row['fecha']), $row['descripcion'], $row['monto'], $row['detalle'], ($row['fecha_asignacion']), $row['cliente'], $row['clave_corta'], $row['captura'], $row['pago'], $row['token'], $row['movimiento'], $row['banco']);
      $item->fecha_cadena = $this->fechaComoCadena($item->fecha);
      $item->fecha_captura_cadena = $this->fechaComoCadena($item->fecha_captura);
      if($item->descripcion == 'Traspaso'){
        $item->movimiento = 'Traspaso entre cuentas';
      }
      $item->saldo_acreditable = $row['saldo_acreditable'];
      array_push($array, $item);
    }

    return $array;

  }


}



