<?php
include_once('conectorBDS14.php');
include_once("adminConceptos.php");

class FormaPago
{
  public $id;
  public $clave;
  public $forma_pago;
  public $accion;

  function __construct($id, $clave, $forma_pago)
  {
    $this->id = $id;
    $this->clave = $clave;
    $this->forma_pago = $forma_pago;
  }
}


class ConceptoFac{
  //SELECT `id`, `id_factura`, `id_producto`, `cantidad`, `precio_unitario`, `precio_con_iva`, `precio_neto`, `precio_neto_iva`, `concepto` FROM `detalle_factura` WHERE 1
  public $id;
  public $id_factura;
  public $id_producto;
  public $cantidad;
  public $precio_unitario;
  public $precio_con_iva;
  public $precio_neto;
  public $precio_neto_iva;
  public $concepto;


  function __construct()
  { 
      $this->id = 0;

  }

}

//`facturas` (`id`, `fecha`, `nombre`, `metodo_pago`, `moneda`, `forma_pago`, `status_pago`, `total_factura`, `empresa`, `estatus_cert`, `certificado`, `cadena`, `id_factura`, `razon`, `tipo_factura`, `total_sin_iva`, `total_iva`, `empresa_destino`, `token`, `tipo_comprobante`, `uso_cfdi`, `num_certificado`, `certificado_fact`, `uuid`, `fecha_timbrado`, `hora_timbrado`, `sello_cfd`, `num_certificado_sat`, `sello_sat`, `complemento`, `id_pago`, `requiere_complemento`, `factura_manual`, `id_clave_corta`, `xml_firmado`, `status`, `enviado`, `cuadrado`, `id_captura`, `status_error`, `folio`, `usuario_crea`, `serie`, `retencion_transporte`, `xml_total`, `xml_subtotal`)

class Factura
{
  public $id;
  public $fecha;
  public $nombre;
  public $metodo_pago;
  public $moneda;
  public $forma_pago;
  public $status_pago;
  public $total_factura;
  public $empresa;
  public $estatus_cert;
  public $certificado;
  public $cadena;
  public $id_factura;
  public $razon;
  public $tipo_factura;
  public $total_sin_iva;
  public $total_iva;
  public $empresa_destino;
  public $token;
  public $tipo_comprobante;
  public $uso_cfdi;
  public $num_certificado;
  public $certificado_fact;
  public $uuid;
  public $fecha_timbrado;
  public $hora_timbrado;
  public $sello_cfd;
  public $num_certificado_sat;
  public $sello_sat;
  public $complemento;
  public $id_pago;
  public $requiere_complemento;
  public $factura_manual;
  public $id_clave_corta;
  public $xml_firmado;
  public $status;
  public $enviado;
  public $cuadrado;
  public $id_captura;
  public $status_error;
  public $folio;
  public $usuario_crea;
  public $serie;
  public $retencion_transporte;
  public $xml_total;
  public $xml_subtotal;
  public $cliente;
  public $empresa_nombre;
  public $empresa_rfc;
  public $metodo_pago_nombre;
  public $forma_pago_nombre;
  public $conceptos;
  public $numeroPago;
  public $saldo;

  function __construct()
  {
    $this->id = 0;
  }
}

class AdministradorFormasPago extends conectorS14
{



  public function agregaFactura($nombre, $metodo_pago, $moneda, $forma_pago, $estatus_pago, $razon, $total_iva, $token, $tipo_comprobante, $uso_cfdi, $id_clave_corta, $id_captura, $folio, $usuario_crea, $serie, $retencion_transporte, $xml_total, $xml_subtotal)
  {

    $sql = "INSERT INTO facturas (nombre, metodo_pago, moneda, forma_pago, status_pago, razon, total_iva, token, tipo_comprobante, uso_cfdi, id_clave_corta, id_captura, folio, usuario_crea, serie, retencion_transporte, xml_total, xml_subtotal, factura_manual) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$estatus_pago', '$razon', '$total_iva', '$token', '$tipo_comprobante', '$uso_cfdi', '$id_clave_corta', '$id_captura', '$folio', '$usuario_crea', '$serie', '$retencion_transporte', '$xml_total', '$xml_subtotal', '1')";
    $this->ejecutar($sql);
    $id = $this->ultimoIdInsertado();
    return $id;
  }

  public function agregaFacturaComplemento($nombre, $metodo_pago, $moneda, $forma_pago, $estatus_pago, $razon, $total_iva, $token, $tipo_comprobante, $uso_cfdi, $id_clave_corta, $id_captura, $folio, $usuario_crea, $serie, $retencion_transporte, $xml_total, $xml_subtotal)
  {

    $sql = "INSERT INTO facturas (nombre, metodo_pago, moneda, forma_pago, status_pago, razon, total_iva, token, tipo_comprobante, uso_cfdi, id_clave_corta, id_captura, folio, usuario_crea, serie, retencion_transporte, xml_total, xml_subtotal, factura_manual) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$estatus_pago', '$razon', '$total_iva', '$token', '$tipo_comprobante', '$uso_cfdi', '$id_clave_corta', '$id_captura', '$folio', '$usuario_crea', '$serie', '$retencion_transporte', '$xml_total', '$xml_subtotal', '1')";
    $this->ejecutar($sql);
    $id = $this->ultimoIdInsertado();
    return $id;
  }

  public function cuentaComplementos($factura){
    $sql = "SELECT id_factura, COUNT(id_factura) as numero FROM `facturar_rel_complementos`  where id_factura = $factura group by id_factura;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $numero = $fila['numero'];
    //cuenta el numero de pagos que se han hecho y le suma uno para sacar el proximo indice recomendado
    return intval($numero) + 1;
  }

  public function sumaSaldos($factura){
    $sql = "SELECT id_factura, SUM(monto) as suma FROM `facturar_rel_complementos` where id_factura = $factura group by id_factura;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $numero = $fila['suma'];
    return floatval($numero);
  }

  function agregarConcepto($id_factura, $id_producto, $cantidad, $precio_unitario, $precio_con_iva, $precio_neto, $precio_neto_iva, $concepto, $iva)
  {
    $sql = "INSERT INTO detalle_factura (id_factura, id_producto, cantidad, precio_unitario, precio_con_iva, precio_neto, precio_neto_iva, concepto, iva) VALUES ('$id_factura', '$id_producto', '$cantidad', '$precio_unitario', '$precio_con_iva', '$precio_neto', '$precio_neto_iva', '$concepto', '$iva')";
    $this->ejecutar($sql);
  }

  public function ultimoIdInsertado()
  {
    $sql = "SELECT MAX(id) as id FROM facturas";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $id = $fila['id'];
    return $id;
  }

  public function compuebaFolioFiscal($id){
    $sql = "SELECT uuid FROM facturas WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $folio = $fila['uuid'];
    //echo $folio;
    if( strlen($folio)>1 ){
      return true;
    }else{
      return false;
    }
  
  }

  public function dameFolioFiscal($id){
    $sql = "SELECT uuid FROM facturas WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $folio = $fila['uuid'];
    return $folio;
  }

  public function relacionaFactura($id_factura, $id_pago)
  {
    $sql = "UPDATE `pagos` SET `id_factura` = '$id_factura' WHERE `pagos`.`id` = $id_pago;";
    $this->ejecutar($sql);
  }

  public function agregarFavorito($usuario, $factura, $nota)
  {
    $sql = "INSERT INTO `facturas_fav` (`id_usuario`, `id_factura`, `nota`) VALUES ('$usuario', '$factura', '$nota');";
    $this->ejecutar($sql);
  }

  public function dameConceptosPorFactura($factura){
    $sql = "SELECT * FROM detalle_factura WHERE id_factura = '$factura'";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new ConceptoFac();
      $concepto->id = $fila['id'];
      $concepto->id_factura = $fila['id_factura'];
      $concepto->id_producto = $fila['id_producto'];
      $concepto->cantidad = $fila['cantidad'];
      $concepto->precio_unitario = $fila['precio_unitario'];
      $concepto->precio_con_iva = $fila['precio_con_iva'];
      $concepto->precio_neto = $fila['precio_neto'];
      $concepto->precio_neto_iva = $fila['precio_neto_iva'];
      $concepto->concepto = $fila['concepto'];
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }


  public function dameFacturasPPD(){
    $sql = "SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
    FROM facturas
            INNER JOIN metodos_pago
            ON facturas.metodo_pago = metodos_pago.id
            INNER JOIN empresas
            ON facturas.razon = empresas.id
            WHERE facturas.forma_pago = 23
            ORDER BY facturas.id ASC";
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];

      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->empresa_nombre = $fila['razon'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);

    }
    return $facturas;


  }

  public function dameFacturasFavoritas($usuario, $empresa)
  {
    $adminConceptos = new AdministradorConceptos();
    $sql = '
      select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
         inner join clientes c 
         on c.id = f.nombre 
         inner join empresas e 
         on e.id  = f.razon 
         inner join formas_pago fp 
         on fp.id = f.forma_pago 
         inner join metodos_pago mp 
         on mp.id = f.metodo_pago 
         inner join facturas_fav fv
       on f.id = fv.id_factura
         where fv.id_usuario = ' . $usuario . ' and e.id = ' . $empresa . '
         order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->conceptos = $adminConceptos->dameConceptosPorFactura($factura->id);
      array_push($facturas, $factura);
    }
    return $facturas;
  }


  public function dameComplementos()
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas_complementos f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasEmpresaRazon($empresa, $razon)
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  
    where f.razon = ' . $empresa . ' and f.id_clave_corta = ' . $razon . '  and f.metodo_pago = 2 order by f.id desc limit 1000';
    //echo $sql;
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->numeroPago = $this->cuentaComplementos($factura->id);
      $factura->saldo = $factura->total_factura -  $this->sumaSaldos($factura->id);
      array_push($facturas, $factura);
    }
    return $facturas;
  }



  public function dameFacturas($cliente)
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago
    where f.nombre = '.$cliente.'
    order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFactura($id){
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago where f.id = '.$id.';';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $factura = new Factura();
    $factura->id = $fila['id'];
    $factura->fecha = $fila['fecha'];
    $factura->nombre = $fila['nombre'];
    $factura->metodo_pago = $fila['metodo_pago'];
    $factura->moneda = $fila['moneda'];
    $factura->forma_pago = $fila['forma_pago'];
    $factura->status_pago = $fila['status_pago'];
    $factura->total_factura = $fila['total_factura'];
    $factura->empresa = $fila['empresa'];
    $factura->estatus_cert = $fila['estatus_cert'];
    $factura->certificado = $fila['certificado'];
    $factura->cadena = $fila['cadena'];
    $factura->id_factura = $fila['id_factura'];
    $factura->razon = $fila['razon'];
    $factura->tipo_factura = $fila['tipo_factura'];
    $factura->total_sin_iva = $fila['total_sin_iva'];
    $factura->total_iva = $fila['total_iva'];
    $factura->empresa_destino = $fila['empresa_destino'];
    $factura->token = $fila['token'];
    $factura->tipo_comprobante = $fila['tipo_comprobante'];
    $factura->uso_cfdi = $fila['uso_cfdi'];
    $factura->num_certificado = $fila['num_certificado'];
    $factura->certificado_fact = $fila['certificado_fact'];
    $factura->uuid = $fila['uuid'];
    $factura->fecha_timbrado = $fila['fecha_timbrado'];
    $factura->hora_timbrado = $fila['hora_timbrado'];
    $factura->sello_cfd = $fila['sello_cfd'];
    $factura->num_certificado_sat = $fila['num_certificado_sat'];
    $factura->sello_sat = $fila['sello_sat'];
    $factura->complemento = $fila['complemento'];
    $factura->id_pago = $fila['id_pago'];
    $factura->requiere_complemento = $fila['requiere_complemento'];
    $factura->factura_manual = $fila['factura_manual'];
    $factura->id_clave_corta = $fila['id_clave_corta'];
    $factura->xml_firmado = $fila['xml_firmado'];
    $factura->status = $fila['status'];
    $factura->enviado = $fila['enviado'];
    $factura->cuadrado = $fila['cuadrado'];
    $factura->id_captura = $fila['id_captura'];
    $factura->status_error = $fila['status_error'];
    $factura->folio = $fila['folio'];
    $factura->usuario_crea = $fila['usuario_crea'];
    $factura->serie = $fila['serie'];
    $factura->retencion_transporte = $fila['retencion_transporte'];
    $factura->xml_total = $fila['xml_total'];
    $factura->xml_subtotal = $fila['xml_subtotal'];
    $factura->cliente = $fila['cliente_nombre'];
    $factura->empresa_nombre = $fila['empresa_nombre'];
    $factura->empresa_rfc = $fila['empresa_rfc'];
    $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
    $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
    $factura->conceptos = $this->dameConceptosPorFactura($factura->id);
    return $factura;
  }

  public function dameFacturasPorMonto($monto, $fecha, $cliente)
  {
    $montoSup = $monto + 0.3;
    $montoInf = $monto - 0.3;
    $fechaMin = date('Y-m-d', strtotime('-6 month', strtotime($fecha)));
    $fechaMax = date('Y-m-d', strtotime('+6 month', strtotime($fecha)));
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where f.total_factura > ' . $montoInf . ' and  f.total_factura < ' . $montoSup . ' and f.fecha_timbrado > "' . $fechaMin . '" and f.fecha_timbrado < "' . $fechaMax . '"  and f.nombre = ' . $cliente . ' order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasSinTimbrar($cliente)
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where fecha_timbrado is null and nombre = '.$cliente.'
    order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasBusqueda($busqueda, $cliente)
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where f.id like "%' . $busqueda . '%" or  f.fecha like "%' . $busqueda . '%" or f.nombre like "%' . $busqueda . '%" or mp.metodo_pago like "%' . $busqueda . '%" or fp.forma_pago like "%' . $busqueda . '%" or e.razon like "%' . $busqueda . '%" or total_factura = "' . $busqueda . '" or status_pago like "%' . $busqueda . '%" or c.nombre like "%' . $busqueda . '%" or fecha_timbrado like "%' . $busqueda . '%" or uuid like "%' . $busqueda . '%" or e.rfc like "%' . $busqueda . '%" and nombre = '.$cliente.'
    order by f.id desc;';
    //echo $sql;
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function cuentaFacturas()
  {
    $sql = 'select count(*) as cuenta from facturas';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }

  public function cuentaFacturasCliente($cliente)
  {
    $sql = 'select count(*) as cuenta from facturas where nombre = ' . $cliente . ";";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }
  public function cuentaFacturasSinTimbrar()
  {
    $sql = 'select count(*) as cuenta from facturas where fecha_timbrado is null';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }

  public function nuevaFormaPago($forma_pago)
  {
    $sql = "INSERT INTO formas_pago (forma_pago) VALUES ('$forma_pago')";
    $this->ejecutar($sql);
  }
  public function dameFormasPago()
  {
    $sql = "SELECT * FROM formas_pago";
    $result = $this->ejecutar($sql);
    $formasPago = array();
    while ($fila = mysqli_fetch_array($result)) {
      $formaPago = new FormaPago($fila['id'], $fila['clave'], $fila['forma_pago']);
      $formaPago->accion = '<a href="cat-formas-pago-mod?id=' . $fila['id'] . '"> <div class="circle long">
      <p>Ver</p>
    </div> </a>';
      array_push($formasPago, $formaPago);
    }
    return $formasPago;
  }

  public function dameFormaPago($id)
  {
    $sql = "SELECT * FROM formas_pago WHERE id = $id";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $formaPago = new FormaPago($fila['id'], $fila['clave'], $fila['forma_pago']);
    return $formaPago;
  }

  public function cuentaFormasPago()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM formas_pago";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }
}
