<?php

include_once('conectorBDS14.php');

class TipoCambio
{
  public $id;
  public $fecha;
  public $hora;
  public $tipo_cambio;

  function __construct($id, $fecha, $hora, $tipo_cambio)
  {
    $this->id = $id;
    $this->fecha = $fecha;
    $this->hora = $hora;
    $this->tipo_cambio = $tipo_cambio;
  }
}


class ClienteUtil
{
  public $nombre;
  public $id;

  public function __construct($nombre, $id)
  {
    $this->nombre = $nombre;
    $this->id = $id;
  }
}

class CuentasUtil
{
  public $id;
  public $nombre_corto;

  public function __construct($id, $nombre_corto)
  {
    $this->id = $id;
    $this->nombre_corto = $nombre_corto;
  }
}

class EstadCliente
{
  public $id;
  public $nombre;
  public $aportacion;

  public function __construct($id, $nombre, $aportacion)
  {
    $this->id = $id;
    $this->nombre = $nombre;
    $this->aportacion = $aportacion;
  }
}

class EstadTiempo
{
  public $anio;
  public $mes;
  public $aportacion;

  public function __construct($anio, $mes, $aportacion)
  {
    $this->anio = $anio;
    $this->mes = $mes;
    $this->aportacion = $aportacion;
  }
}

class AdministradorUtil extends conectorS14
{
  public function dameUltimoTipoCambio()
  {
    $sql = 'SELECT * FROM tipo_cambio order by id desc LIMIT 1';
    $result = $this->ejecutar($sql);
    $tipo_cambio = array();
    while ($fila = mysqli_fetch_array($result)) {
      $tipo_cambio = new TipoCambio($fila['id'], $fila['fecha'], $fila['hora'], $fila['tipo_cambio']);
    }
    return $tipo_cambio;
  }

  public function dameEstadisticasClienteFecha($fechaInicio, $fechaFin)
  {
    $sql = "SELECT clientes.id, clientes.nombre, sum(saldo_acreditable) as aportacion FROM pagos 
    LEFT join clientes on pagos.cliente_origen_comision = clientes.id
    WHERE pagos.nombre = '1' and pagos.tipo_movimiento = 'Abono por comisión' and pagos.fecha_asignacion < '$fechaFin' and pagos.fecha_asignacion > '$fechaInicio' 
    GROUP BY clientes.id
    order by aportacion desc;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadCliente($row['id'], $row['nombre'], $row['aportacion']);
    }
    return $items;
  }

  public function dameEstadisticasCliente()
  {
    $sql = "SELECT clientes.id, clientes.nombre, sum(saldo_acreditable) as aportacion FROM pagos 
    LEFT join clientes on pagos.cliente_origen_comision = clientes.id
    WHERE pagos.nombre = '1' and pagos.tipo_movimiento = 'Abono por comisión'
    GROUP BY clientes.id
    order by aportacion desc;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadCliente($row['id'], $row['nombre'], $row['aportacion']);
    }
    return $items;
  }
  public function dameReporteCliente($fechaInicio, $fechaFin, $cliente)
  {
    $sql = "SELECT
    YEAR(fecha_asignacion) AS anio,
    MONTH(fecha_asignacion) AS mes,
    sum(saldo_acreditable) AS aportacion
  FROM pagos
  WHERE
    pagos.nombre = '1'
    AND pagos.tipo_movimiento = 'Abono por comisión'
    AND pagos.fecha_asignacion < '$fechaFin'
    AND pagos.fecha_asignacion > '$fechaInicio'
    AND pagos.cliente_origen_comision = $cliente
  GROUP BY anio, mes;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadTiempo($row['anio'], $row['mes'], $row['aportacion']);
    }
    return $items;
  }

  public function dameUltimos5TiposCambio()
  {
    $sql = 'SELECT * FROM tipo_cambio order by id desc LIMIT 5';
    $result = $this->ejecutar($sql);
    $tipo_cambio = array();
    while ($fila = mysqli_fetch_array($result)) {
      $tipo_cambio[] = new TipoCambio($fila['id'], $fila['fecha'], $fila['hora'], $fila['tipo_cambio']);
    }
    return $tipo_cambio;
  }

  public function dameNombreClientePrincipal()
  {
    $sql = 'SELECT nombre from clientes where id=1';
    $result = $this->ejecutar($sql);

    while ($fila = mysqli_fetch_array($result)) {
      $empresa = $fila['nombre'];
    }
    return $empresa;
  }

  public function dameSaldoAcreditableClientePrincipal()
  {
    $sql = 'SELECT sum(saldo_acreditable) as suma from pagos where nombre=1';
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function dameMontoEnFila()
  {
    $sql = "select sum(monto) as suma from pre_ejecuta_plantilla where status = 'EJECUTADO' and estado IS NULL and id_stp IS NOT NULL and fecha_creacion > '2023-11-00' ORDER BY `id` DESC;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }


  public function dameSaldoInternos()
  {
    $sql = "select sum(saldo_acreditable) as suma from pagos where nombre='13'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function cuentaMovimientosPendientes()
  {
    $sql = "SELECT COUNT(id) AS movimientos FROM pagos WHERE STATUS <>'asignado'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $movimientos = $fila['movimientos'];
    }
    return $movimientos;
  }

  public function sumaDepositos()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Deposito' and bancos.moneda<>'Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function sumaRetiros()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Retiro' and bancos.moneda<>'Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function sumaDepositosDolares()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Deposito' and bancos.moneda='Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function sumaRetirosDolares()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Retiro' and bancos.moneda='Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function dameSaldoMovimientosTotal()
  {
    $depositos = $this->sumaDepositos();
    $retiros = $this->sumaRetiros();
    $depositos_dolares = $this->sumaDepositosDolares();
    $retiros_dolares = $this->sumaRetirosDolares();
    $tipo_cambio = $this->dameUltimoTipoCambio()->tipo_cambio;
    $suma = $depositos - $retiros;
    $suma_dolares = ($depositos_dolares - $retiros_dolares);
    $suma_dolares_pesos = $suma_dolares * $tipo_cambio;

    $suma_movimientos = $suma + $suma_dolares_pesos;
    return $suma_movimientos;
  }

  public function dameDiferenciasDeSaldo()
  {
    $sql = "SELECT ((SELECT SUM(deposito) FROM captura_edo_cta)-(SELECT SUM(retiro) FROM captura_edo_cta)) - 
    (SELECT SUM(saldo_acreditable) FROM pagos)
    AS resto";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $resto = $fila['resto'];
    }



    return $resto - $this->dameSaldoMovimientosTotal();
  }

  public function dameSaldosStp()
  {
    $sql = "SELECT saldo FROM stp_saldos WHERE id=(SELECT MAX(id) FROM stp_saldos)";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

  public function dameOperacionesPendientesStp()
  {
    $sql = "SELECT cargos_pendientes FROM stp_saldos WHERE id=(SELECT MAX(id) FROM stp_saldos)";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $saldos = $fila['cargos_pendientes'];
    }
    return $saldos;
  }

  public function aplicaIva($id)
  {
    $sql = "SELECT aplica_iva FROM `conceptos` WHERE id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['aplica_iva'];
  }

  public function damePrecioSinIva($id)
  {
    $sql = "SELECT precio FROM `conceptos` WHERE id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['precio'];
  }

  public function dameClientes()
  {
    $sql = "SELECT id, nombre FROM `clientes` ORDER BY nombre ASC";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new ClienteUtil($row['nombre'], $row['id']);
    }
    return $items;
  }
  public function dameCliente($id)
  {
    $sql = "SELECT cliente FROM `usuarios` WHERE id = $id";
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['cliente'];
  }
  public function cuentaFacturasPpdPorCliente($id)
  {
    $sql = "SELECT count(*) AS numrows FROM `facturas_complementos` WHERE metodo_pago = 2 and nombre = '.$id.' AND id NOT IN (SELECT id_complemento FROM `facturar_rel_complementos` WHERE restante = 0)";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['numrows'];
  }

  public function dameClientePorPago($id)
  {
    $sql = "SELECT clientes.id, clientes.nombre, clientes.correo FROM pagos INNER JOIN clientes ON (pagos.destino_traspaso = clientes.id) WHERE pagos.id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['id'];
  }

  public function dameCorreoCliente($id)
  {
    $sql = "SELECT correo FROM `clientes` WHERE id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['correo'];
  }

  public function dameCuentas()
  {
    $sql = "SELECT id,nombre_corto FROM bancos order by nombre_corto";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new CuentasUtil($row['id'], $row['nombre_corto']);
    }
    return $items;
  }

  public function dameSumaEmpresas()
  {
    $sql = "SELECT (sum(deposito) - SUM(retiro)) as total FROM `captura_edo_cta` inner join bancos on bancos.id = captura_edo_cta.cuenta where bancos.status_banco = 'AC';";
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['total'];
  }
}
