<?php
session_start();
require 'excel_reader2.php';

include_once 'conectorBD.php';
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);

class Movimiento {
    public $id;
    public $nombre;
    public $targeta;
    public $monto;
    public $banco;
	public $tipo;
	public $cat_id_banco;
	public $error;

    public function __construct($id, $nombre, $targeta, $monto, $banco, $tipo, $cat_id_banco, $error) {
        $this->id = $id;
        $this->nombre = $nombre;
        $this->targeta = $targeta;
        $this->monto = $monto;
        $this->banco = $banco;
		$this->tipo = $tipo;
		$this->cat_id_banco = $cat_id_banco;
		$this->error = $error;
    }
}


function dameBancoCat($nombre){
	$conector = new conector();
	$sql = "SELECT * FROM `stp_cat_bancos` WHERE `razon_social_completa` LIKE '%".$nombre."%'";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['cve_id'];
}

function dameNombreBanco($clave){
	$conector = new conector();
	$sql = "SELECT * FROM `stp_cat_bancos` WHERE `cve_id` LIKE '%".$clave."%'";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['nombre_corto'];
}

function dameSaldoStp(){
	$conector = new conector();
	$sql = "SELECT * FROM `stp_saldos` ORDER BY id DESC limit 1;";
	$result = $conector->ejecutar($sql);
	$row = mysqli_fetch_array($result);
	//echo"Analizando " .  $row['cve_id'] . " PARA " . $nombre . "<br>" ;
	return $row['saldo'];
}

 function dameSaldoCliente($cliente)
{
$conector = new conector();
  $sql = "select sum(saldo_acreditable) as suma from pagos where nombre='$cliente'";
  $result = $conector->ejecutar($sql);
  $fila = mysqli_fetch_array($result);
  return $fila['suma'];
}


function limpiaNombre($nombre){
	$nombre = str_replace('ñ', 'n', $nombre);
	$nombre = str_replace('Ñ', 'N', $nombre);
	$nombre = str_replace('á', 'a', $nombre);
	$nombre = str_replace('Á', 'A', $nombre);
	$nombre = str_replace('é', 'e', $nombre);
	$nombre = str_replace('É', 'E', $nombre);
	$nombre = str_replace('í', 'i', $nombre);
	$nombre = str_replace('Í', 'I', $nombre);
	$nombre = str_replace('ó', 'o', $nombre);
	$nombre = str_replace('Ó', 'O', $nombre);
	$nombre = str_replace('ú', 'u', $nombre);
	$nombre = str_replace('Ú', 'U', $nombre);
	$nombre = str_replace('ü', 'u', $nombre);
	$nombre = str_replace('Ü', 'U', $nombre);
	return $nombre;

}


function processXLSFile($filePath) {
	$movimientos = array();
    $data = new Spreadsheet_Excel_Reader($filePath, false);
	$data->setUTFEncoder('mb');

	echo '[';
	$saldo =  dameSaldoCliente($_POST['cliente']);
	$saldoStp = dameSaldoStp();
    $totalSheets = count($data->sheets);
    
    for ($sheet = 0; $sheet < $totalSheets; $sheet++) {
        $rowCount = $data->sheets[$sheet]['numRows'];
        $colCount = $data->sheets[$sheet]['numCols'];
        
        
        for ($row = 1; $row <= $rowCount; $row++) {
				//echo "Analizando fila " . $row . "<br>";
				$comprovante = "DATA ". $data->sheets[$sheet]['cells'][$row][1];
				if(strpos($comprovante, 'NOMBRE') !== false || $data->sheets[$sheet]['cells'][$row][1] == "" || $data->sheets[$sheet]['cells'][$row][1] == " " ){
					$saltar = true;
				}
				else{
					$saltar = false;
				}
	
				if (!$saltar) { // Saltar la primera fila (encabezado)
					$id = $row-1;
					$error = "Correcto";
					$nombre = $data->sheets[$sheet]['cells'][$row][1];
					$nombre = limpiaNombre($nombre);
					$targeta = $data->sheets[$sheet]['cells'][$row][2];
					$monto = $data->sheets[$sheet]['cells'][$row][3];
					$digitos = strlen($targeta);
					$targeta = str_replace(' ', '', $targeta);
					$targeta = str_replace('-', '', $targeta);
					$targeta = str_replace('X', '', $targeta);
					$targeta = str_replace('x', '', $targeta);
					$targeta = str_replace('.', '', $targeta);
					$monto = str_replace('$', '', $monto);
					$monto = str_replace(',', '', $monto);
					$monto = str_replace(' ', '', $monto);
					//echo $row  . " Analizando " . $monto . " de " . $digitos . " digitos <br>";
					if($digitos==16){
						$banco = determinaBanco($targeta);
					}
					else if($digitos == 18){
						$banco = new stdClass(); // Crear un objeto vacío para representar $banco
						$banco->bank = new stdClass(); // Crear un objeto vacío para representar $banco->bank
						$primeros_tres_digitos = substr($targeta, 0, 3);//extrae los primeros 3 digitos
						$banco->bank->name = dameNombreBanco($primeros_tres_digitos); // Asignar un valor a $banco->bank->name
					}
					$nombrebanco = $banco->bank->name;
					$idBancoCat = dameBancoCat($nombrebanco);
	
	
					//contar digitos targeta 
					$damanioNombre = strlen($nombre);
					$saldo = $saldo - $monto;
					$saldoStp = $saldoStp - $monto;

					if($saldo < 0){
						if($_SESSION["usuario_id"] != 1){
							$error = "Saldo cliente insuficiente";
						}
					}
					
					if($saldoStp < 0){
						$error = "Saldo STP insuficiente";
					}
					//determinar tipo de targeta
					if($banco == null || $banco->bank->name == null){
						$error = "Banco no reconocido";
					}
					if($digitos == 16){
						$tipo = "TARJETA";
					}
					else if($digitos == 18){
						$tipo = "CUENTA";
					}
					else{
						$tipo = "OTRO";
						$error = "Targeta o clave incorrecta (Digitos: " . $digitos . " no validos)";
					}
					if($damanioNombre < 1){
						$error = "Nombre no valido";
					}
					if($monto <= 0){
						$error = "Monto no valido";
					}

					
					
					$movimiento = new Movimiento($id, $nombre, $targeta, $monto, $banco, $tipo, $idBancoCat, $error);
					$movimientos[] = $movimiento;
					if(json_encode($movimiento) != null || json_encode($movimiento) != ""){
						echo json_encode($movimiento);
						echo ',';
					}
				
						//usleep(500000);


				}
			
			  
        }
        
    }
	echo '{}]';
	//echo json_encode($movimientos);
}



/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code has been removed, and the file is now safe to use.
*/

