<?php

include_once("adminClientes.php");
$adminClientes = new AdministradorClientes();
$clientes = $adminClientes->dameClientes();

foreach($clientes as $cliente){
  if($cliente->notificar_saldo){
    $saldo = floatval($adminClientes->dameSaldoInmediato($cliente->id)); 
    $conteo = intval($adminClientes->cuentaMovimientosHoy($cliente->id)) ;
    echo "Cliente: ".$cliente->id."  con saldo ".$saldo . "  con movimientos  ".$conteo." <br>";
    echo "<br><br>";
    enviarMensaje(limpiarNombre($cliente->nombre) , $saldo, $conteo);
  }

}


function limpiarNombre($nombre){
  $nombre = str_replace("á", "a", $nombre);
  $nombre = str_replace("é", "e", $nombre);
  $nombre = str_replace("í", "i", $nombre);
  $nombre = str_replace("ó", "o", $nombre);
  $nombre = str_replace("ú", "u", $nombre);
  $nombre = str_replace("Á", "A", $nombre);
  $nombre = str_replace("É", "E", $nombre);
  $nombre = str_replace("Í", "I", $nombre);
  $nombre = str_replace("Ó", "O", $nombre);
  $nombre = str_replace("Ú", "U", $nombre);
  $nombre = str_replace("ñ", "n", $nombre);
  $nombre = str_replace("Ñ", "N", $nombre);
  $nombre = str_replace("ü", "u", $nombre);
  $nombre = str_replace("Ü", "U", $nombre);
  $nombre = str_replace("Ü", "U", $nombre);
  $nombre = str_replace("'", "", $nombre);
  $nombre = str_replace('"', "", $nombre);




  return $nombre;

}


function enviarMensaje($nombre, $saldo, $conteo){
  
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://graph.facebook.com/v17.0/130840453454957/messages',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'
{
  "messaging_product": "whatsapp",
  "to": "523315448344",
  "type": "template",
  "template": {
    "name": "s_saldos",
    "language": {
      "code": "es"
    },
    "components": [
           {
        "type": "HEADER",
        "index": 0,
        "parameters": [
            {
                "type": "text",
                "text": "'.$nombre.'"
            }
        ]
    },
         {
        "type": "body",
        "index": 0,
        "parameters": [
            {
                "type": "text",
                "text": "'.$nombre.'"
            },
             {
                "type": "text",
                "text": "$ '. number_format($saldo , 2)  .'"
            }
            ,
             {
                "type": "text",
                "text": "'.$conteo.'"
            }
        ]
    }
    ]
  }
}',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Bearer EABraG1mmqU0BOZC8i15L0OwPgtNGpagYtrx86JH5LdZC9y1SREr0VJbkj1ZAmkEZBhfwmuVXwQ7rd2jTMfpSjv0Yi7RURgWP0GZAM8LEi7nMb04ZAsBZAsoPFYQHygsvEZCoLprd598xYgRPnDXMifLpjMHm15xyz9QRUZC1jpgtIOsn6hd2vN1D1z2CHMRTEHQ0ubrKwfaffFpfEJlSZB',
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
//esperar 2 segundos 
sleep(2);
}