<?php
include_once('conectorBDS14.php');

class Captura
{
  public $id;
  public $razon;
  public $nombre_corto;
  public $captura;
  public $fecha;
  public $hora;
  public $accion;
  public $fechaEliminacion;
  public $horaEliminacion;
  public $usuarioElimino;
  public $empresa_id;
  public $banco_id;

  function __construct($id, $razon, $nombre_corto, $captura, $fecha, $hora)
  {
    $this->id = $id;
    $this->razon = $razon;
    $this->nombre_corto = $nombre_corto;
    $this->captura = $captura;
    $this->fecha = $fecha;
    $this->hora = $hora;
  }
}


class AdministradorCapturas extends conectorS14
{

  public function dameCapturas()
  {
    $sql = "SELECT captura.*,bancos.banco, empresas.razon as razonE, bancos.nombre_corto FROM captura INNER JOIN bancos ON (bancos.id=captura.`nombre_corto`) 
    INNER JOIN empresas
    on empresas.id = captura.razon
    ORDER BY captura.id DESC limit 1000;";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new Captura($fila['id'], $fila['razonE'], $fila['nombre_corto'], "", $fila['fecha'], $fila['hora']);
      array_push($capturas, $captura);
    }
    return $capturas;
  }


  public function dameCapturasEliminadas()
  {
    $sql = "SELECT captura_eliminadas.*,bancos.banco, bancos.id as banco_id,  empresas.razon as razonE, empresas.id as empresa_id, bancos.nombre_corto, usuarios.nombre as nombreUser FROM captura_eliminadas 
    INNER JOIN bancos ON (bancos.id=captura_eliminadas.`nombre_corto`) 
    INNER JOIN empresas on empresas.id = captura_eliminadas.razon 
    INNER JOIN usuarios on usuarios.id = captura_eliminadas.usuario_elimina
    ORDER BY captura_eliminadas.id DESC limit 1000;";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new Captura($fila['id'], $fila['razonE'], $fila['nombre_corto'], "", $fila['fecha'], $fila['hora']);
      $captura->fechaEliminacion = $fila['fecha_elimina'];
      $captura->usuarioElimino = $fila['nombreUser'];
      $captura->empresa_id = $fila['empresa_id'];
      $captura->banco_id = $fila['banco_id'];
      array_push($capturas, $captura);
    }
    return $capturas;
  }

  public function dameCapturaEliminada($id)
  {
    $sql = "SELECT captura_eliminadas.*,bancos.banco, bancos.id as banco_id,  empresas.razon as razonE, empresas.id as empresa_id, bancos.nombre_corto, usuarios.nombre as nombreUser FROM captura_eliminadas 
    INNER JOIN bancos ON (bancos.id=captura_eliminadas.`nombre_corto`) 
    INNER JOIN empresas on empresas.id = captura_eliminadas.razon 
    INNER JOIN usuarios on usuarios.id = captura_eliminadas.usuario_elimina
    WHERE captura_eliminadas.id = '$id'
    ORDER BY captura_eliminadas.id DESC limit 1000;";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $capturas = array();
    $fila = mysqli_fetch_array($result);
    $captura = new Captura($fila['id'], $fila['razonE'], $fila['nombre_corto'], "", $fila['fecha'], $fila['hora']);
    $captura->fechaEliminacion = $fila['fecha_elimina'];
    $captura->usuarioElimino = $fila['nombreUser'];
    $captura->empresa_id = $fila['empresa_id'];
    $captura->banco_id = $fila['banco_id'];
    $captura->captura = $fila['captura'];
    array_push($capturas, $captura);

    return $captura;
  }

  public function dameCaptura($id)
  {
    $sql = "SELECT captura.*,bancos.banco, empresas.razon as razonE, bancos.nombre_corto FROM captura INNER JOIN bancos ON (bancos.id=captura.`nombre_corto`) 
    INNER JOIN empresas
    on empresas.id = captura.razon
    WHERE captura.id = '$id';";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $captura = new Captura($fila['id'], $fila['razonE'], $fila['nombre_corto'], $fila['captura'], $fila['fecha'], $fila['hora']);
    return $captura;
  }

  public function dameCapturaSimple($id){
    $sql = "SELECT * from captura WHERE captura.id = '$id';";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $captura = new Captura($fila['id'], $fila['razon'], $fila['nombre_corto'], $fila['captura'], $fila['fecha'], $fila['hora']);
    return $captura;
  }

  public function dameCapturasManuales(){
    $sql = "SELECT captura.*,bancos.banco, empresas.razon as razonE, bancos.nombre_corto FROM captura INNER JOIN bancos ON (bancos.id=captura.`nombre_corto`) 
    INNER JOIN empresas
    on empresas.id = captura.razon
    WHERE captura.captura = 'Captura Manual'
    ORDER BY captura.id DESC limit 1000;";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new Captura($fila['id'], $fila['razonE'], $fila['nombre_corto'], "", $fila['fecha'], $fila['hora']);
      array_push($capturas, $captura);
    }
    return $capturas;
  }


  public function dameUltimaId()
  {
    $sql = "SELECT MAX(id) AS id FROM captura";
    $result = $this->ejecutar($sql);
    $id = mysqli_fetch_array($result);
    $id = $id['id'];
    return $id;
  }

  public function insertaCaptura($razon, $nombre_corto, $captura)
  {
    $fecha = date("Y-m-d");
    $hora = date("H:i:s");
    $sql = "INSERT INTO captura (razon, nombre_corto, captura, fecha, hora) VALUES ('$razon', '$nombre_corto', '$captura', '$fecha', '$hora')";
    $result = $this->ejecutar($sql);
    return $this->dameUltimaId();
  }

  public function insertaCapturaTemporal($razon, $nombre_corto, $captura, $fecha, $hora)
  {
    $sql = "INSERT INTO captura_t (razon, nombre_corto, captura, fecha, hora) VALUES ('$razon', '$nombre_corto', '$captura', '$fecha', '$hora')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function dameUltimoIdCapturaTemporal()
  {
    $sql = "SELECT MAX(id) AS id FROM captura_t";
    $result = $this->ejecutar($sql);
    $id = mysqli_fetch_array($result);
    $id = $id['id'];
    return $id;
  }

  public function cuentaCapturas()
  {
    $sql = "SELECT COUNT(*) AS total FROM captura";
    $result = $this->ejecutar($sql);
    $total = mysqli_fetch_array($result);
    $total = $total['total'];
    return $total;
  }

  public  function insertaCapturaEliminada($razon, $nombre_corto, $captura, $fecha, $hora, $usuario_elimina){
    $sql = "INSERT INTO captura_eliminadas (razon, nombre_corto, captura, fecha, hora, usuario_elimina, fecha_elimina) VALUES ('$razon', '$nombre_corto', '$captura', '$fecha', '$hora', '$usuario_elimina', now())";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function eliminarCaptura($id){
    $sql = "DELETE FROM captura WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function eliminarPagosPorCaptura($id){
    $sql = "DELETE FROM pagos WHERE id_captura = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function  eliminaEstadoPorCaptura($id){
    $sql = "DELETE FROM captura_edo_cta WHERE id_captura = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }
}

