<?php
include_once('conectorBDS14.php');

class Concepto
{
  public $id;
  public $concepto;
  public $clave_sat;
  public $clave_producto;
  public $clave_unidad_medida;
  public $precio_min;
  public $precio_max;
  public $razon;
  public $unidades_max;
  public $facturable_auto;
  public $aplica_iva;
  public $objeto_impuesto;
  public $impuesto;
  public $nombreEmpresa;
  public $botonRuta;
  public $cantidad;
  public $precioUnitario;

  public function __construct($id, $concepto, $clave_sat, $clave_producto, $clave_unidad_medida, $precio_min, $precio_max, $razon, $unidades_max, $facturable_auto, $aplica_iva, $objeto_impuesto, $impuesto, $nombreEmpresa)
  {
    $this->id = $id;
    $this->concepto = $concepto;
    $this->clave_sat = $clave_sat;
    $this->clave_producto = $clave_producto;
    $this->clave_unidad_medida = $clave_unidad_medida;
    $this->precio_min = $precio_min;
    $this->precio_max = $precio_max;
    $this->razon = $razon;
    $this->unidades_max = $unidades_max;
    $this->facturable_auto = $facturable_auto;
    $this->aplica_iva = $aplica_iva;
    $this->objeto_impuesto = $objeto_impuesto;
    $this->impuesto = $impuesto;
    $this->nombreEmpresa = $nombreEmpresa;
  }
}

class AdministradorConceptos extends conectorS14
{
  public function insertarConcepto($concepto, $clave_sat, $clave_producto, $clave_unidad_medida, $precio_min, $precio_max, $razon, $unidades_max, $facturable_auto, $aplica_iva, $objeto_impuesto, $impuesto)
  {
    $sql = "INSERT INTO conceptos (concepto, clave_sat, clave_producto, clave_unidad_medida, precio_min, precio_max, razon, unidades_max, facturable_auto, aplica_iva, objeto_impuesto, impuesto) VALUES ('$concepto', '$clave_sat', '$clave_producto', '$clave_unidad_medida', '$precio_min', '$precio_max', '$razon', '$unidades_max', '$facturable_auto', '$aplica_iva', '$objeto_impuesto', '$impuesto')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function dameConcepto($id)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.id = $id";
    $result = $this->ejecutar($sql);
    $concepto = mysqli_fetch_array($result);
    $concepto = new Concepto($concepto['id'], $concepto['concepto'], $concepto['clave_sat'], $concepto['clave_producto'], $concepto['clave_unidad_medida'], $concepto['precio_min'], $concepto['precio_max'], $concepto['razon'], $concepto['unidades_max'], $concepto['facturable_auto'], $concepto['aplica_iva'], $concepto['objeto_impuesto'], $concepto['impuesto'], $concepto['empresaNom']);
    return $concepto;
  }

  public function dameConceptosPorFactura($factura)
  {
    $sql = '
    SELECT conceptos.*, detalle_factura.cantidad, detalle_factura.precio_con_iva, detalle_factura.concepto as cfo FROM `conceptos`
    inner join detalle_factura
    on detalle_factura.id_producto = conceptos.id

    where detalle_factura.id_factura = ' . $factura . ';
    ';
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['cfo'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], "");
      $concepto->cantidad = $fila['cantidad'];
      $concepto->precioUnitario = $fila['precio_con_iva'];
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosPorRazon($razon)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.razon = $razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosPorRazonFactura($razon)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.razon = $razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptos()
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      $concepto->botonRuta = '<a href="cat-conceptos-form.php?id=' . $fila['id'] . '"> <div class="circle long">
                                <p>Ver</p>
                              </div> </a>';
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }
  public function cuentaConceptos()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM conceptos";
    $result = $this->ejecutar($sql);
    $cuenta = mysqli_fetch_array($result);
    $cuenta = $cuenta['cuenta'];
    return $cuenta;
  }
  public function cuentaConceptosSinIva()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM conceptos WHERE aplica_iva = 'no'";
    $result = $this->ejecutar($sql);
    $cuenta = mysqli_fetch_array($result);
    $cuenta = $cuenta['cuenta'];
    return $cuenta;
  }

  public function cuentaConceptosConIva()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM conceptos WHERE aplica_iva = 'si'";
    $result = $this->ejecutar($sql);
    $cuenta = mysqli_fetch_array($result);
    $cuenta = $cuenta['cuenta'];
    return $cuenta;
  }
}
