<?php
include_once('conectorBDS14.php');
include "adminBancos.php";


class ReporteBanco{
    public $id;
    public $fecha_actualisacion;
    public $banco; 
    public $saldo_hoy;
    public $saldo_dia2;
    public $saldo_dia3;
    public $saldo_dia4;

    public function __construct($id, $fecha_actualisacion, $banco, $saldo_hoy, $saldo_dia2, $saldo_dia3, $saldo_dia4)
    {
        $this->id = $id;
        $this->fecha_actualisacion = $fecha_actualisacion;
        $this->banco = $banco;
        $this->saldo_hoy = $saldo_hoy;
        $this->saldo_dia2 = $saldo_dia2;
        $this->saldo_dia3 = $saldo_dia3;
        $this->saldo_dia4 = $saldo_dia4;
    }

}




function obtenerUltimasTresFechas()
{
    $resultados = [];
    $fecha = new DateTime();
    $resultados[] = date('Y-m-d');

    for ($i = 0; $i < 3; $i++) {
        $fecha->modify('-1 day');
        if (queDiaSemanaEs($fecha->format('Y-m-d')) == 0) {
            $fecha->modify('-2 day');
        }
        if (queDiaSemanaEs($fecha->format('Y-m-d')) == 6) {
            $fecha->modify('-1 day');
        }
        $resultados[] = $fecha->format('Y-m-d');
    }

    //añadir hoy 

    return $resultados;
}

function queDiaSemanaEs($fecha)
{
    $dia = date('w', strtotime($fecha));
    return $dia;
}


function dameSuma3Dias($empresa)
{
    $fechas = obtenerUltimasTresFechas();
    $suma = 0;
    $datos = [];

    foreach ($fechas as $fecha) {
        //echo "Esta es la fecha " . $fecha;
        $saldo =  dameSaldosPorFechasRetiros($empresa, $fecha);
        $datos[] =  $saldo;
        $suma = $suma + $saldo;
    }

    $datos[] = "TOTAL: " . number_format($suma, 2);
    return $datos;
}


function dameSaldosPorFechasRetiros($empresa, $fecha)
{
    $conector = new conectorS14();

    $sql = "SELECT sum(retiro) as suma FROM `captura_edo_cta` where cuenta = $empresa and fecha = '$fecha';";
    //echo $sql;
    $result = $conector->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
}

function fechaComoCadenaScript($fecha)
  {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);

    switch ($mes) {
      case "01":
        $mes = 'Enero';
        break;
      case "02":
        $mes = 'Febrero';
        break;
      case "03":
        $mes = 'Marzo';
        break;
      case  "04":
        $mes = 'Abril';
        break;
      case "05":
        $mes = 'Mayo';
        break;
      case "06":
        $mes = 'Junio';
        break;
      case "07":
        $mes = 'Julio';
        break;
      case "08":
        $mes = 'Agosto';
        break;
      case "09":
        $mes = 'Septiembre';
        break;
      case "10":
        $mes = 'Octubre';
        break;
      case "11":
        $mes = 'Noviembre';
        break;
      case "12":
        $mes = 'Diciembre';
        break;
      default:
        $mes = "NA";
        $dia = "NA";
        $anio = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
  }

$adminBancos = new AdministradorBanco();
$bancos  = $adminBancos->dameBancos();
$conector = new conectorS14();
//no tocar, esto borra todo el historial de saldos
$sql = "delete from his_saldos_bancos";
$conector->ejecutar($sql);


foreach ($bancos as $banco) {

    $fechasSa = array();
    $fechas = obtenerUltimasTresFechas();
    echo $banco->nombre_corto . "<br>";

    foreach($fechas as $fecha){
        $saldos = dameSaldosPorFechasRetiros($banco->id, $fecha);
        $fechasSa[] = $saldos;
    }

    //SELECT `id`, `fecha_actualisacion`, `banco`, `saldo_hoy`, `saldo_dia2`, `saldo_dia3`, `saldo_dia4` FROM `his_saldos_bancos` WHERE 1
    $hoy = fechaComoCadenaScript($fechas[0]) . " : $" . number_format(floatval($fechasSa[0]),2) ;
    $dia2 = fechaComoCadenaScript($fechas[1]) . " : $" .  number_format(floatval($fechasSa[1]),2);
    $dia3 = fechaComoCadenaScript($fechas[2]) . " : $" .  number_format(floatval($fechasSa[2]),2);
    $dia4 =  fechaComoCadenaScript($fechas[3]) . " : $" .  number_format(floatval($fechasSa[3]),2);
    $sql = "INSERT INTO `his_saldos_bancos`(`fecha_actualisacion`, `banco`, `saldo_hoy`, `saldo_dia2`, `saldo_dia3`, `saldo_dia4`) VALUES (now(),$banco->id, '$hoy','$dia2','$dia3','$dia4')";
    $conector->ejecutar($sql);
    echo $sql . "<br>";

}


